<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>ABCA ADMIN</title>
    <meta content='width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no' name='viewport'>

    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <!-- Theme style -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.3/css/AdminLTE.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.3/css/skins/_all-skins.min.css">

    <!-- iCheck -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/skins/square/_all.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/css/select2.min.css">

    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.7.14/css/bootstrap-datetimepicker.min.css">

    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">

    <link rel="stylesheet" href="{{asset('css/admin-style.css')}}">

    @yield('css')
    @yield('head')




</head>

<body class="skin-blue sidebar-mini admin-body">
@if (!Auth::guest())
    <div class="wrapper">
        <!-- Main Header -->
        <header class="main-header">
            <!-- Logo -->
            <a href="{{ url('/')}}" class="logo">
                <b>I</b>
            </a>

            <!-- Header Navbar -->
            <nav class="navbar navbar-static-top" role="navigation">
                <!-- Sidebar toggle button-->
                <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
                    <span class="sr-only">Toggle navigation</span>
                </a>
                <!-- Navbar Right Menu -->
                <div class="navbar-custom-menu">
                    <ul class="nav navbar-nav">
                        <!-- User Account Menu -->
                        <li class="dropdown user user-menu">
                            <!-- Menu Toggle Button -->
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                <!-- The user image in the navbar-->
                                <img src="/images/logo-red-black.png"
                                     class="user-image" alt="User Image"/>
                                <!-- hidden-xs hides the username on small devices so only the image appears. -->
                                <span class="hidden-xs">{{ Auth::user()->name }}</span>
                            </a>
                            <ul class="dropdown-menu">
                                <!-- The user image in the menu -->
                                <li class="user-header">
                                    <img src="/images/logo-red-black.png"
                                         class="img-circle" alt="User Image"/>
                                    <p>
                                        {{ Auth::user()->name }}
                                        <small>Member since {{ Auth::user()->created_at->format('M. Y') }}</small>
                                    </p>
                                </li>
                                <!-- Menu Footer-->
                                <li class="user-footer">
                                    <div class="pull-left">
                                        <a href="#" class="btn btn-default btn-flat">Profile</a>
                                    </div>
                                    <div class="pull-right">
                                        <a href="{{ url('/logout') }}" class="btn btn-default btn-flat"
                                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                            Sign out
                                        </a>
                                        <form id="logout-form" action="{{ url('/logout') }}" method="POST" style="display: none;">
                                            @csrf
                                        </form>
                                    </div>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <!-- Left side column. contains the logo and sidebar -->
        {{-- {{ dd( \App\Models\User::find(Auth::user()->id)->roles->pluck('name','id') ) }} --}}
        {{-- @if($userRole = \App\Models\User::find(Auth::user()->id)->roles->pluck('name','id')->all()) --}}
            {{-- @foreach ($userRole as $key => $value)
                @if($key==1)
                    @include('sidebar.super_admin')  
                @elseif($key==2)
                    @include('sidebar.admin')  
                @else
                    @include('sidebar.super_admin')  
                @endif
            @endforeach
        @endif --}}
        {{-- {{ dd(\App\User::find(1)->getDirectPermissions()) }} --}}
        {{-- {{ dd(Auth::user()->roles->pluck('name')) }} --}}

        @role('Super Admin')
            @include('sidebar.super_admin')
        @endrole

        @role('Alumni Membership')
            @include('sidebar.alumni_membership')
            {{-- admin@admin.com --}}
            {{-- alumni_membership@thaat.com --}}
            {{-- registration@thaat.com --}}
            {{-- carrier@thaat.com --}}
            {{-- event@thaat.com --}}
            {{-- research_publication@thaat.com --}}
            {{-- news@thaat.com --}}
        @endrole

        @role('Registration')
            @include('sidebar.registration')
        @endrole

        @role('Carrier')
            @include('sidebar.carrier')
        @endrole

        @role('Event')
            @include('sidebar.event')
        @endrole

        @role('Research Publication')
            @include('sidebar.research_publication')
        @endrole

        @role('News')
            @include('sidebar.news')
        @endrole


        {{-- a. News
        // b. Alumni Membership 
        // c. Registration
        // d. Carrier
        // e. Event
        // d. Research Publication --}}

        {{-- @role('Admin')
            @include('sidebar.admin')
        @endrole

        @role('Teacher')
            @include('sidebar.teacher')
        @endrole

        @role('Student')
            @include('sidebar.student')
        @endrole --}}


        {{-- @include('layouts.sidebar') --}}
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            {{-- @include('components.errors') --}}
            @yield('content')
        </div>

        <!-- Main Footer -->
        <footer class="main-footer" style="max-height: 100px;text-align: center;">
            Copyright © 2020 | All rights reserved | <strong>Powered By <a target="_blank" href="https://www.technohaat.com/">Technohaat</a></strong>
        </footer>

    </div>
@else
    <nav class="navbar navbar-default navbar-static-top">
        <div class="container">
            <div class="navbar-header">

                <!-- Collapsed Hamburger -->
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
                        data-target="#app-navbar-collapse">
                    <span class="sr-only">Toggle Navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>

                <!-- Branding Image -->
                <a class="navbar-brand" href="{{ url('/') }}">
                    School
                </a>
            </div>

            <div class="collapse navbar-collapse" id="app-navbar-collapse">
                <!-- Left Side Of Navbar -->
                <ul class="nav navbar-nav">
                    <li><a href="{{ url('/home') }}">Home</a></li>
                </ul>

                <!-- Right Side Of Navbar -->
                <ul class="nav navbar-nav navbar-right">
                    <!-- Authentication Links -->
                    <li><a href="{{ url('/login') }}">Login</a></li>
                    <li><a href="{{ url('/register') }}">Register</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <div id="page-content-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    @yield('content')
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- jQuery 3.1.1 -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.15.1/moment.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"></script>
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
    <!-- AdminLTE App -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.3/js/adminlte.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/js/select2.min.js"></script>



    <script src="{{asset('js/custom.js')}}"></script>

    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>

    <script>

        var base_url = {!! json_encode(url('/')) !!}
        
        $(document).ready(function() {
          $('.summernote').summernote({
            height: 400,
            callbacks: {
                        onImageUpload: function(files, editor, welEditable) {
                            // upload image to server and create imgNode...
                            var that = $(this);
                            sendFile(files[0], editor, welEditable, that);
                          }
                        }
          });
        });


        function sendFile(file, editor, welEditable, that) {
                          data = new FormData();
                          data.append("file", file);
                          $.ajax({
                              data: data,
                              type: "POST",
                              url: base_url + "/admin/upload_summernote_photo",
                              cache: false,
                              contentType: false,
                              processData: false,
                              success: function(url) {
                                $(that).summernote('insertImage', url)
                              }
                          });
                        }


        // $(document).ready(function() {
        //   $('.summernote').summernote({
        //     height: 400
        //   });
        // });
    </script>


    @stack('scripts')
    @yield('bodyScope')

</body>
</html>