<div class="table-responsive">
    <table class="table" id="stories-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
        <th>Image</th>
        <th>Status</th>
                <th colspan="3">Action</th>
            </tr>
        </thead>
        <tbody>
        @foreach($stories as $story)
            <tr>
                <td>{{$story->id}}</td>
                <td>{{ $story->name }}</td>
            <td>{!! $story->imageToShow() !!}</td>
            <td>{!! $story->status_buttons() !!}</td>
                <td>
                    {!! Form::open(['route' => ['admin.stories.destroy', $story->id], 'method' => 'delete']) !!}
                    <div class='btn-group'>
                        <a href="{{ route('admin.stories.show', [$story->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-eye-open"></i></a>
                        <a href="{{ route('admin.stories.edit', [$story->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-edit"></i></a>
                        {!! Form::button('<i class="glyphicon glyphicon-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'onclick' => "return confirm('Are you sure?')"]) !!}
                    </div>
                    {!! Form::close() !!}
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>
