<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jobs', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title')->nullable();
            $table->integer('salary')->nullable();
            $table->integer('salary_negotialble')->nullable();
            $table->string('position')->nullable();
            $table->text('description')->nullable();
            $table->text('description_additional')->nullable();
            $table->datetime('dead_line');
            $table->string('cmp_name')->nullable();
            $table->string('cmp_website')->nullable();
            $table->text('cmp_image')->nullable();
            $table->text('cmp_description')->nullable();
            $table->string('cmp_location')->nullable();
            $table->integer('completed')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('status')->nullable();
            $table->timestamps();
        });

        
        $file = realpath(__DIR__.'/../catalogs/jobs.sql');
        DB::unprepared( file_get_contents($file) );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('jobs');
    }
}
