<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlidersTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sliders', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title')->nullable();
            $table->string('title_sub')->nullable();
            $table->text('image')->nullable();
            $table->text('description')->nullable();
            $table->string('read_more_title')->nullable();
            $table->string('read_more_link')->nullable();
            $table->integer('status')->nullable();
            $table->timestamps();
        });

        $file = realpath(__DIR__.'/../catalogs/sliders.sql');
        DB::unprepared( file_get_contents($file) );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('sliders');
    }
}
