<?php

namespace App\Models;

use \App\Model as Model;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Image;

use Illuminate\Foundation\Auth\User as Authenticatable;

class Student extends Authenticatable implements JWTSubject
{

    public $upload_path = 'uploads/students';

    public $table = 'students';

    protected $hidden = [
        'password',
    ];
    
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function scopeWithSearch($query){
        $keyword = request()->keyword;
        $search_fields = $this->search_fields;
        // dd($search_fields);

        if(request('keyword')){

            if(count($search_fields)){
                foreach ($search_fields as $field) {
                    $query = $query->orWhere( $field, 'like', '%' . $keyword . '%');
                }
            }
        }
        return $query;
    }

    public function scopeActive($query){
        return $query->where('status', 1);
    }


    public function status_buttons($field='status'){
        $status = $this->getOriginal($field);

        if($status){
            return '<button type="button" class="btn btn-success btn-sm">Yes</button>';
        }
        return '<button type="button" class="btn btn-danger btn-sm">No</button>';
    }
    
    public function deleteImage($field)
    {
        $image = $this->getOriginal($field);
        if (empty($image)) {
            return true;
        }
        // dd($this->getOriginal($field));
        $post_data_photo = public_path($this->upload_path . "/{$image}"); // get previous image from folder
        if (\File::exists($post_data_photo)) { // unlink or remove previous image from folder
            unlink($post_data_photo);
        }
    }

    public function delete_existing_and_upload_file($field, $save_title='', $path=null){
        if(request()->hasfile($field)) 
        { 
          $this->deleteImage($field); // if older image exists

          $filename = $this->uploadFile($field, $save_title, $path);
          return $filename;
        }
        return $this->$field;

    }

    public function imageToShow( $field='image', $upload_directory=null, $width="50"){
        $path = $upload_directory ? $upload_directory : $this->upload_path;

        $post_data_photo = public_path($path . "/{$this->$field}"); // get previous image from folder
        if (\File::exists($post_data_photo) && $this->$field) { // unlink or remove previous image from folder
            return "<img width='{$width}' src='". asset($path) . '/' . $this->$field."'>";
            
        }

        return '';
    }


    public $search_fields = [
        'username',
        'password',
        'name',
        'degree',
        'major',
        'nuc',
        'gyear',
        'award_status',
        'awname',
        'awtime',
        'awcertificate',
        'occupation',
        'workplace',
        'address',
        'email',
        'phone',
        'wechat',
        'message',
        'user_type',
        'reset_token',
        'reset_token_expire_in_min',
        'update_request',
        'status'
    ];
    public $fillable = [
        'username',
        'password',
        'name',
        'degree',
        'major',
        'nuc',
        'gyear',
        'g_photo', // new
        'p_photo', // new
        'award_status',
        'awname',
        'awtime',
        'awcertificate',
        'occupation',
        'workplace',
        'address',
        'email',
        'phone',
        'wechat',
        'gender', //new
        'message',
        'user_type',
        'reset_token',
        'reset_token_expire_in_min',
        'update_request',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'username' => 'string',
        'password' => 'string',
        'name' => 'string',
        'degree' => 'string',
        'major' => 'string',
        'nuc' => 'string',
        'gyear' => 'string',
        'award_status' => 'string',
        'awname' => 'string',
        'awtime' => 'string',
        'awcertificate' => 'string',
        'occupation' => 'string',
        'workplace' => 'string',
        'address' => 'string',
        'email' => 'string',
        'phone' => 'string',
        'wechat' => 'string',
        'message' => 'string',
        'user_type' => 'string',
        'reset_token' => 'string',
        'reset_token_expire_in_min' => 'string',
        'update_request' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        // 'username' => 'required',
        // 'password' => 'required',
        'name' => 'required',
        'degree' => 'required',
        'nuc' => 'required',
        'gyear' => 'required',
        'occupation' => 'required',
        'email' => 'required',
        'phone' => 'required',
        'user_type' => 'required'
    ];

    public function uploadFile($field, $save_title='', $path=null){
        //dd($field_name);
        $path = $path ? $path : $this->upload_path;
        if(request()->hasfile($field)) 
        { 
          $field_instance = request()->file($field);
          if($field_instance){
                $extension = $field_instance->getClientOriginalExtension(); // getting image extension
                $filename = remove_space_dots_replace_underscore($save_title) . '_' . time() . mt_rand(1000, 9999) . '.'.$extension;
                $field_instance->move(public_path($path), $filename);
                return $filename;
            }
        }
        return null;
    }

    public function uploadFileVue($field_or_field_with_request, $save_title='', $path=null, $request_method = false){
        // return($field);
        $path = $path ? $path : $this->upload_path;

        $has_profile_photo = $request_method ? $field_or_field_with_request : request($field_or_field_with_request);

        if($has_profile_photo){
            $extension = $has_profile_photo->getClientOriginalExtension(); // getting image extension
            $filename =  remove_space_dots_replace_underscore($save_title) . '_' . time() . mt_rand(1000, 9999) . '.'.$extension;

            Image::make($has_profile_photo)->save(public_path($path).$filename);
            return $filename;
        }
        return null;
    }  





    
}
