<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class MemberCategory
 * @package App\Models
 * @version March 29, 2021, 7:49 am UTC
 *
 * @property string name
 * @property integer status
 */
class MemberCategory extends Model
{

    public $table = 'member_categories';
    
    public function members(){
        return $this->hasMany('\App\Models\Member', 'category_id', 'id');
    }
    
    public $upload_path = 'uploads/member_categories';

    public $search_fields = [
        'name',
        'status'
    ];
    public $fillable = [
        'name',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required'
    ];

    
}
