<?php

namespace App\Models;

use \App\Model as Model;
use Mail;

class Email extends Model
{

    public static $test_mode = false;
    public static $test_email = 'rodroahshan@gmail.com';

    public static $from_email = 'no_reply@abc-alumni.org';
    public static $admin_email = 'no_reply@abc-alumni.org';


    public static function send_email(){

        $from = self::$from_email;
        $from_name = setting('app_name');

        $subject = "Forgot Password";
        $text_body = 'Your Passcode Token 3459';

        $to = self::$test_email;
        $data = \App\Models\Student::get()->first();

        Mail::send('email.template.forgot_password', ['data' => $data, 'subject' => $subject, 'text_body' => $text_body],
	          function ($message) use ($to,$from,$from_name,$subject){
	              $message->from($from,$from_name);
	              $message->to($to)->subject($subject);
	     });
    }


    public static function send_forgot_password_email($student_data){

        $from = self::$from_email;
        $from_name = setting('app_name');

        $subject = "Forgot Password";
        $text_body = 'Your Passcode Token ' . $student_data->reset_token;

        $to = self::$test_mode ? self::$test_email : $student_data->email;

        $mail_send = Mail::send('email.template.forgot_password',['data' => $student_data, 'subject' => $subject, 'text_body' => $text_body],
              function ($message) use ($to,$from,$from_name,$subject){
                  $message->from($from,$from_name);
                  $message->to($to)->subject($subject);
         });

        return true;
    }


    public static function approve_alumunis_profile($student_data){

        $from = self::$from_email;
        $from_name = setting('app_name');

        $subject = "Approved";
        $text_body = 'Hi, ' . $student_data->name . ' We have approved your profile and credential. You can login now.';

        $to = self::$test_mode ? self::$test_email : $student_data->email;

        $mail_send = Mail::send('email.template.approved_profile',['data' => $student_data, 'subject' => $subject, 'text_body' => $text_body],
              function ($message) use ($to,$from,$from_name,$subject){
                  $message->from($from,$from_name);
                  $message->to($to)->subject($subject);
         });

        return true;
    }


    public static function new_alumunis_profile($student_data){

        $from = self::$from_email;
        $from_name = setting('app_name');

        $subject = "New Alumuni Account Request: " . $student_data->name;
        $text_body = 'Hi, Admin you got a new alumuni registration. Please check and approve';

        $to = self::$test_mode ? self::$test_email : self::$admin_email;

        $mail_send = Mail::send('email.template.approved_profile',['data' => $student_data, 'subject' => $subject, 'text_body' => $text_body],
              function ($message) use ($to,$from,$from_name,$subject){
                  $message->from($from,$from_name);
                  $message->to($to)->subject($subject);
         });

        return true;
    }


    public static function notify_contact_details_to_admin($contact_data){

        $from = self::$from_email;
        $from_name = setting('app_name');

        $subject = "New Contact Information";
        $text_body = 'Hi, You have got new contact Information. Please check admin panel';

        $to = self::$test_mode ? self::$test_email : self::$admin_email;

        $mail_send = Mail::send('email.template.contact_email_to_admin',['data' => $contact_data, 'subject' => $subject, 'text_body' => $text_body],
              function ($message) use ($to,$from,$from_name,$subject){
                  $message->from($from,$from_name);
                  $message->to($to)->subject($subject);
         });

        return true;
    }



}
