<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Contact
 * @package App\Models
 * @version April 10, 2021, 2:48 pm UTC
 *
 * @property string name
 * @property string email
 * @property string subject
 * @property string message
 * @property integer status
 */
class Contact extends Model
{

    public $table = 'contacts';
    




    public $upload_path = 'uploads/contacts';

    public $search_fields = [
        'name',
        'email',
        'subject',
        'message',
        'status'
    ];
    public $fillable = [
        'name',
        'email',
        'subject',
        'message',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'email' => 'string',
        'subject' => 'string',
        'message' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
        'email' => 'required'
    ];

    
}
