<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StudentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $student = new \App\Models\Student;
        $array =  parent::toArray($request);
        $array['graduation_image_src'] = url('/') . '/uploads/graduation_photo/' . $this->g_photo;
        $array['profile_image_src'] = url('/') . '/uploads/profile_photo/' . $this->p_photo;
        $array['gyear_html5'] = date('Y-m-d', strtotime($this->gyear));
        $array['awtime_html5'] = date('Y-m-d', strtotime($this->awtime));
        $array['formatted_date'] = formated_date($this->created_at);
        return $array;
    }
}
