<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $story = new \App\Models\Story;
        $array =  parent::toArray($request);
        $array['short_description'] = \Illuminate\Support\Str::limit(strip_tags($this->description), $limit = 250, $end = '...');
        $array['youtube_id'] = getYouTubeIdFromURL($this->youtube_src);
        $array['date_formated'] = formated_date($this->created_at);
        $array['image_src'] = url('/') . '/' . $story->upload_path . '/' . $this->image;
        $array['video_src_src'] = url('/') . '/' . $story->upload_video_path . '/' . $this->video_src;
        return $array;
    }
}
