<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\Member;

class MemberResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $member = new Member;
        $array =  parent::toArray($request);
        $array['image_src'] = url('/') . '/' . $member->upload_path . '/' . $this->image;
        $array['short_description'] = \Illuminate\Support\Str::limit(strip_tags($this->description), $limit = 200, $end = '...');

        return $array;
    }
}
