<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Student;
use DB;
use Flash;
use Illuminate\Http\Request;

class WebController extends Controller
{


    public function page_show($id){
        $page = \App\Page::find($id);
        return view('front.pages.pages.show', compact('page'));
    }
    public function blogs(){
        $blogs = \App\Models\Blog::latest()->active()->paginate(10);
    	return view('front/pages/blogs/index')->with('blogs', $blogs);
    }

    public function blog_show($id){
        $blog = \App\Models\Blog::find($id);
    	return view('front/pages/blogs/show')->with('blog', $blog);
    }

    public function home(){
        return redirect('login');
    	// return view('front/pages/access_information_payment');
        //return view('front/pages/home');
    }

    public function courses(){
        return view('front.pages.courses.show');
    }

    public function student_register(){
    	return view('front/pages/student_register');
    }

    public function student_register_store(Request $request, Student $student){

        $request->validate([
            'name' => 'required',
            'phone' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required',
            // 'gender' => 'required',
            // 'student_type' => 'required',
            // 'email' => 'required|email',
            // 'image' => 'image|mimes:jpeg,png,jpg|max:2048'
        ]);


        // when path null its come from model upload_path
        DB::beginTransaction();
        try {
            $input = $request->all();



            // $input['image'] = $student->uploadFile($field = 'image', $save_title=$request->name, $path=null);

            if($request->email && $request->password){

                $user = new \App\User;
                $user->name = $request->name;
                $user->email = $request->email;
                $user->password = bcrypt($request->password);
                $user->save();

                $user->assignRole('Student');
            }

            unset($input['password']);

            $input['user_id'] = $user->id;
            /** @var Student $student */
            $student = Student::create($input);

            DB::commit();

            // $package = \App\Models\Package::find($request->package_id)->toArray();

            // $transaction = \App\Models\Transaction::store_transaction($package, $payment_type=1, $user->id, $student->id);

            // $paypal_response = \App\Models\PayPal::payment($transaction);

            // return redirect($paypal_response['paypal_link']);

            \Auth::login($user);

            Flash::success('Registration & Login Success');

            return redirect('/home');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            Flash::success('Some Thing is wrong.');
            return back();
        }

        Flash::success('Student saved successfully.');

        return redirect(url('/'));
    }


    // public function student_register_store(Request $request, Student $student){

    //     $request->validate([
    //         'name' => 'required',
    //         'phone' => 'required',
    //         'email' => 'required|email|unique:users',
    //         'password' => 'required',
    //         // 'gender' => 'required',
    //         // 'student_type' => 'required',
    //         // 'email' => 'required|email',
    //         // 'image' => 'image|mimes:jpeg,png,jpg|max:2048'
    //     ]);


    //     // when path null its come from model upload_path
    //     DB::beginTransaction();
    //     try {
    //         $input = $request->all();



    //         $input['image'] = $student->uploadFile($field = 'image', $save_title=$request->name, $path=null);

    //         if($request->email && $request->password){

    //             $user = new \App\User;
    //             $user->name = $request->name;
    //             $user->email = $request->email;
    //             $user->password = bcrypt($request->password);
    //             $user->save();

    //             $user->assignRole('Student');
    //         }

    //         unset($input['password']);

    //         $input['user_id'] = $user->id;
    //         /** @var Student $student */
    //         $student = Student::create($input);

    //         DB::commit();

    //         $package = \App\Models\Package::find($request->package_id)->toArray();

    //         $transaction = \App\Models\Transaction::store_transaction($package, $payment_type=1, $user->id, $student->id);

    //         $paypal_response = \App\Models\PayPal::payment($transaction);

    //         return redirect($paypal_response['paypal_link']);

    //         // \Auth::login($user);

    //         // Flash::success('Registration & Login Success');

    //         // return redirect('/home');

    //     } catch (\Exception $e) {
    //         DB::rollback();
    //         dd($e);
    //         Flash::success('Some Thing is wrong.');
    //         return back();
    //     }

    //     Flash::success('Student saved successfully.');

    //     return redirect(url('/'));
    // }





}
