<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateStudentRequest;
use App\Http\Requests\UpdateStudentRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\Student;
use Illuminate\Http\Request;


use App\Exports\StudentExport;
use Maatwebsite\Excel\Facades\Excel;


use Flash;
use Response;
use DB;

class StudentController extends AppBaseController
{

    public function old_to_new(){

        die('done already');
        try {
            DB::beginTransaction();


            DB::table('member_registration')->orderBy('id')->chunk(100, function ($members) {

                foreach ($members as $member) {

                    $already_stored = \App\Models\Student::where('email', $member->email)->orWhere('username', $member->username)->first();
                    if($already_stored){
                        continue;
                    }

                    $student = new Student;
                    $student->username = trim($member->username);
                    $student->email = strtolower(trim($member->email));
                    $student->password = bcrypt(trim($member->password));
                    $student->name = $member->name;
                    $student->degree = $member->degree;
                    $student->major = $member->major;
                    $student->nuc = $member->nuc;
                    $student->gyear = $member->gyear;
                    //$student->g_photo = '';
                    //$student->p_photo = '';
                    //$student->award_status = '';
                    //$student->awname = '';
                    //$student->awtime = '';
                    //$student->awcertificate = '';
                    $student->occupation = $member->occupation;
                    $student->workplace = $member->workplace;
                    $student->address = $member->address;
                    $student->phone = $member->phone;
                    $student->wechat = $member->wechat;
                    $student->message = $member->message;
                    //$student->gender = '';
                    //$student->reset_token = '';
                    //$student->reset_token_expire_in_min = '';
                    //$student->update_request = '';
                    $student->user_type = 'alumni';
                    $student->status = 1;
                    $student->created_at = '2021-04-04 19:11:24';
                    $student->updated_at = '2021-04-04 19:11:24';
                    $student->save();
                }
            });

            DB::commit();
            die('success');
       }
       catch( \Execption $e ) {
            DB::rollBack();
            die('wrong');

       }






        //  CODEIGNITER

    //   `id` int(11) NOT NULL,
    //   `username` varchar(100) NOT NULL,
    //   `password` varchar(100) NOT NULL,
    //   `name` varchar(100) NOT NULL,
    //   `degree` varchar(100) NOT NULL,
    //   `major` varchar(300) DEFAULT NULL,
    //   `nuc` varchar(300) NOT NULL,
    //   `gyear` varchar(100) NOT NULL,
    //   `award_status` varchar(100) DEFAULT NULL,
    //   `awname` varchar(100) DEFAULT NULL,
    //   `awtime` varchar(100) DEFAULT NULL,
    //   `awcertificate` varchar(300) DEFAULT NULL,
    //   `occupation` varchar(300) NOT NULL,
    //   `workplace` varchar(300) DEFAULT NULL,
    //   `address` varchar(300) DEFAULT NULL,
    //   `email` varchar(100) NOT NULL,
    //   `phone` varchar(100) NOT NULL,
    //   `wechat` varchar(100) DEFAULT NULL,
    //   `message` varchar(500) DEFAULT NULL,
    //   `user_type` varchar(100) NOT NULL,
    //   `status` int(2) NOT NULL DEFAULT 1


      // LARAVEL
      //   `id` int(11) NOT NULL,
      // `username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `password` text COLLATE utf8mb4_unicode_ci NOT NULL,
      // `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `degree` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `major` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `nuc` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'univercity name',
      // `gyear` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `g_photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'graduation photo',
      // `p_photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Profile photo',
      // `award_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `awname` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `awtime` datetime DEFAULT NULL,
      // `awcertificate` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `occupation` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `workplace` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `address` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `wechat` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `message` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `gender` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `reset_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `reset_token_expire_in_min` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `update_request` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
      // `status` int(11) DEFAULT NULL,
      // `created_at` timestamp NULL DEFAULT NULL,
      // `updated_at` timestamp NULL DEFAULT NULL


    }




    public function index(Request $request)
    {
        /** @var Student $students */
        $students = Student::withSearch()->latest()->paginate(10);

        return view('admin.students.index')
            ->with('students', $students);
    }

    public function print(){
        /** @var Student $students */
        $students = Student::withSearch()->latest()->get();

        return view('admin.students.print')
            ->with('students', $students);

    }


    public function export_csv()
    {
        return Excel::download(new StudentExport, 'alumuni.xlsx');
    }


    public function update_request(Request $request)
    {
        /** @var Student $students */
        $students = Student::where('update_request', 1)->withSearch()->latest()->paginate(10);

        return view('admin.students.index')
            ->with('students', $students);
    }

    public function accept_update_request($id){
        $student = \App\Models\Student::find($id);
        $student->update_request = 0;
        $student->save();

        Flash::success('Success');
        return back();

    }


    public function approve_request($id){
        $student = \App\Models\Student::find($id);
        $student->status = 1;
        $student->save();

        \App\Models\Email::approve_alumunis_profile($student);

        Flash::success('Success');
        return back();

    }

    public function decline_request($id){
        $student = \App\Models\Student::find($id);
        $student->status = 0;
        $student->save();

        Flash::success('Success');
        return back();

    }




    /**
     * Show the form for creating a new Student.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.students.create');
    }

    /**
     * Store a newly created Student in storage.
     *
     * @param CreateStudentRequest $request
     *
     * @return Response
     */


    public function store(Request $request){

        $request->validate([

            'username' => 'required|unique:students,username',
            'email' => 'required|unique:students,email',
            'password' => 'required',
            'g_photo'  => $request->award_status ? 'required|image|max:2048' : '',
            'awtime'  => $request->award_status ? 'required' : '',
       ],
       [
       ]);



       try {
            DB::beginTransaction();

            $student = new Student;
            $student->username = $request->username;
            $student->password = bcrypt($request->password);
            $student->name = $request->name;
            $student->degree = $request->degree;
            $student->major = $request->major;
            $student->nuc = $request->nuc;
            $student->gyear = $request->gyear;


            // IMAGE GRADUTAION PHOTO g_photo
            $has_graduation_file = request('g_photo');

            if($has_graduation_file){
                $extension = $has_graduation_file->getClientOriginalExtension(); // getting image extension
                $filename = remove_space_dots_replace_underscore($student->name) . '_' . time() . mt_rand(1000, 9999) . '.'.$extension;

                Image::make($request->g_photo)->save(public_path('uploads/graduation_photo/').$filename);

                $student->g_photo  =  $filename;
            }


            // $student->g_photo = $student->uploadFile($field = 'g_photo', $save_title=$request->name, $path=null);

            $student->award_status = $request->award_status;
            $student->awname = $request->awname;
            $student->awtime = date("Y-m-d H:i:s",strtotime($request->awtime));
            $student->awcertificate = $request->awcertificate;
            $student->occupation = $request->occupation;
            $student->workplace = $request->workplace;
            $student->address = $request->address;
            $student->email = $request->email;
            $student->phone = $request->phone;
            $student->wechat = $request->wechat;
            $student->message = $request->message;

            $student->gender = $request->gender; // new

            $student->user_type = $request->user_type;
            $student->status = 0;

            $student->save();

            DB::commit();
            // DB::rollBack();

            Flash::success('Student saved successfully.');
            return redirect(route('admin.students.index'));
       }
       catch( \Execption $e ) {
            DB::rollBack();

            Flash::success('Something wrong');
            return back();

       }

    }
    // public function store(CreateStudentRequest $request)
    // {
    //     $input = $request->all();

    //     /** @var Student $student */
    //     $student = Student::create($input);

    //     Flash::success('Student saved successfully.');

    //     return redirect(route('admin.students.index'));
    // }

    /**
     * Display the specified Student.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var Student $student */
        $student = Student::find($id);

        if (empty($student)) {
            Flash::error('Student not found');

            return redirect(route('admin.students.index'));
        }

        return view('admin.students.show')->with('student', $student);
    }




    /**
     * Show the form for editing the specified Student.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var Student $student */
        $student = Student::find($id);

        if (empty($student)) {
            Flash::error('Student not found');

            return redirect(route('admin.students.index'));
        }

        return view('admin.students.edit')->with('student', $student);
    }

    /**
     * Update the specified Student in storage.
     *
     * @param int $id
     * @param UpdateStudentRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateStudentRequest $request)
    {
        /** @var Student $student */
        $student = Student::find($id);

        if (empty($student)) {
            Flash::error('Student not found');

            return redirect(route('admin.students.index'));
        }

        $student->fill($request->all());
        $student->save();

        Flash::success('Student updated successfully.');

        return redirect(route('admin.students.index'));
    }

    /**
     * Remove the specified Student from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var Student $student */
        $student = Student::find($id);

        if (empty($student)) {
            Flash::error('Student not found');

            return redirect(route('admin.students.index'));
        }

        $student->delete();

        Flash::success('Student deleted successfully.');

        return redirect(route('admin.students.index'));
    }
}
