<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateStudentAwardRequest;
use App\Http\Requests\UpdateStudentAwardRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\StudentAward;
use Illuminate\Http\Request;
use Flash;
use Response;

class StudentAwardController extends AppBaseController
{

    public function student_awards($student_id, Request $request)
    {
        /** @var StudentAward $studentAwards */
        $studentAwards = StudentAward::withSearch()->where('student_id', $student_id)->latest()->paginate(10);

        return view('admin.student_awards.index')
            ->with('studentAwards', $studentAwards);
    }

    /**
     * Display a listing of the StudentAward.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var StudentAward $studentAwards */
        $studentAwards = StudentAward::withSearch()->latest()->paginate(10);

        return view('admin.student_awards.index')
            ->with('studentAwards', $studentAwards);
    }

    /**
     * Show the form for creating a new StudentAward.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.student_awards.create');
    }

    /**
     * Store a newly created StudentAward in storage.
     *
     * @param CreateStudentAwardRequest $request
     *
     * @return Response
     */
    public function store(CreateStudentAwardRequest $request)
    {
        $input = $request->all();

        /** @var StudentAward $studentAward */
        $studentAward = StudentAward::create($input);

        Flash::success('Student Award saved successfully.');

        return redirect(route('admin.studentAwards.index'));
    }

    /**
     * Display the specified StudentAward.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var StudentAward $studentAward */
        $studentAward = StudentAward::find($id);

        if (empty($studentAward)) {
            Flash::error('Student Award not found');

            return redirect(route('admin.studentAwards.index'));
        }

        return view('admin.student_awards.show')->with('studentAward', $studentAward);
    }

    /**
     * Show the form for editing the specified StudentAward.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var StudentAward $studentAward */
        $studentAward = StudentAward::find($id);

        if (empty($studentAward)) {
            Flash::error('Student Award not found');

            return redirect(route('admin.studentAwards.index'));
        }

        return view('admin.student_awards.edit')->with('studentAward', $studentAward);
    }

    /**
     * Update the specified StudentAward in storage.
     *
     * @param int $id
     * @param UpdateStudentAwardRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateStudentAwardRequest $request)
    {
        /** @var StudentAward $studentAward */
        $studentAward = StudentAward::find($id);

        if (empty($studentAward)) {
            Flash::error('Student Award not found');

            return redirect(route('admin.studentAwards.index'));
        }

        $studentAward->fill($request->all());
        $studentAward->save();

        Flash::success('Student Award updated successfully.');

        return redirect(route('admin.studentAwards.index'));
    }

    /**
     * Remove the specified StudentAward from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var StudentAward $studentAward */
        $studentAward = StudentAward::find($id);

        if (empty($studentAward)) {
            Flash::error('Student Award not found');

            return redirect(route('admin.studentAwards.index'));
        }

        $studentAward->delete();

        Flash::success('Student Award deleted successfully.');

        return redirect(route('admin.studentAwards.index'));
    }
}
