<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateJobSubscriberRequest;
use App\Http\Requests\UpdateJobSubscriberRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\JobSubscriber;
use Illuminate\Http\Request;
use Flash;
use Response;

class JobSubscriberController extends AppBaseController
{
    /**
     * Display a listing of the JobSubscriber.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var JobSubscriber $jobSubscribers */
        $jobSubscribers = JobSubscriber::withSearch()->latest()->paginate(10);

        return view('admin.job_subscribers.index')
            ->with('jobSubscribers', $jobSubscribers);
    }

    /**
     * Show the form for creating a new JobSubscriber.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.job_subscribers.create');
    }

    /**
     * Store a newly created JobSubscriber in storage.
     *
     * @param CreateJobSubscriberRequest $request
     *
     * @return Response
     */
    public function store(CreateJobSubscriberRequest $request)
    {
        $input = $request->all();

        /** @var JobSubscriber $jobSubscriber */
        $jobSubscriber = JobSubscriber::create($input);

        Flash::success('Job Subscriber saved successfully.');

        return redirect(route('admin.jobSubscribers.index'));
    }

    /**
     * Display the specified JobSubscriber.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var JobSubscriber $jobSubscriber */
        $jobSubscriber = JobSubscriber::find($id);

        if (empty($jobSubscriber)) {
            Flash::error('Job Subscriber not found');

            return redirect(route('admin.jobSubscribers.index'));
        }

        return view('admin.job_subscribers.show')->with('jobSubscriber', $jobSubscriber);
    }

    /**
     * Show the form for editing the specified JobSubscriber.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var JobSubscriber $jobSubscriber */
        $jobSubscriber = JobSubscriber::find($id);

        if (empty($jobSubscriber)) {
            Flash::error('Job Subscriber not found');

            return redirect(route('admin.jobSubscribers.index'));
        }

        return view('admin.job_subscribers.edit')->with('jobSubscriber', $jobSubscriber);
    }

    /**
     * Update the specified JobSubscriber in storage.
     *
     * @param int $id
     * @param UpdateJobSubscriberRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateJobSubscriberRequest $request)
    {
        /** @var JobSubscriber $jobSubscriber */
        $jobSubscriber = JobSubscriber::find($id);

        if (empty($jobSubscriber)) {
            Flash::error('Job Subscriber not found');

            return redirect(route('admin.jobSubscribers.index'));
        }

        $jobSubscriber->fill($request->all());
        $jobSubscriber->save();

        Flash::success('Job Subscriber updated successfully.');

        return redirect(route('admin.jobSubscribers.index'));
    }

    /**
     * Remove the specified JobSubscriber from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var JobSubscriber $jobSubscriber */
        $jobSubscriber = JobSubscriber::find($id);

        if (empty($jobSubscriber)) {
            Flash::error('Job Subscriber not found');

            return redirect(route('admin.jobSubscribers.index'));
        }

        $jobSubscriber->delete();

        Flash::success('Job Subscriber deleted successfully.');

        return redirect(route('admin.jobSubscribers.index'));
    }
}
