<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateGalleryCategoryRequest;
use App\Http\Requests\UpdateGalleryCategoryRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\GalleryCategory;
use Illuminate\Http\Request;
use Flash;
use Response;

class GalleryCategoryController extends AppBaseController
{
    /**
     * Display a listing of the GalleryCategory.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var GalleryCategory $galleryCategories */
        $galleryCategories = GalleryCategory::withSearch()->latest()->paginate(10);

        return view('admin.gallery_categories.index')
            ->with('galleryCategories', $galleryCategories);
    }

    /**
     * Show the form for creating a new GalleryCategory.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.gallery_categories.create');
    }

    /**
     * Store a newly created GalleryCategory in storage.
     *
     * @param CreateGalleryCategoryRequest $request
     *
     * @return Response
     */
    public function store(CreateGalleryCategoryRequest $request)
    {
        $input = $request->all();

        /** @var GalleryCategory $galleryCategory */
        $galleryCategory = GalleryCategory::create($input);

        Flash::success('Gallery Category saved successfully.');

        return redirect(route('admin.galleryCategories.index'));
    }

    /**
     * Display the specified GalleryCategory.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var GalleryCategory $galleryCategory */
        $galleryCategory = GalleryCategory::find($id);

        if (empty($galleryCategory)) {
            Flash::error('Gallery Category not found');

            return redirect(route('admin.galleryCategories.index'));
        }

        return view('admin.gallery_categories.show')->with('galleryCategory', $galleryCategory);
    }

    /**
     * Show the form for editing the specified GalleryCategory.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var GalleryCategory $galleryCategory */
        $galleryCategory = GalleryCategory::find($id);

        if (empty($galleryCategory)) {
            Flash::error('Gallery Category not found');

            return redirect(route('admin.galleryCategories.index'));
        }

        return view('admin.gallery_categories.edit')->with('galleryCategory', $galleryCategory);
    }

    /**
     * Update the specified GalleryCategory in storage.
     *
     * @param int $id
     * @param UpdateGalleryCategoryRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateGalleryCategoryRequest $request)
    {
        /** @var GalleryCategory $galleryCategory */
        $galleryCategory = GalleryCategory::find($id);

        if (empty($galleryCategory)) {
            Flash::error('Gallery Category not found');

            return redirect(route('admin.galleryCategories.index'));
        }

        $galleryCategory->fill($request->all());
        $galleryCategory->save();

        Flash::success('Gallery Category updated successfully.');

        return redirect(route('admin.galleryCategories.index'));
    }

    /**
     * Remove the specified GalleryCategory from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var GalleryCategory $galleryCategory */
        $galleryCategory = GalleryCategory::find($id);

        if (empty($galleryCategory)) {
            Flash::error('Gallery Category not found');

            return redirect(route('admin.galleryCategories.index'));
        }

        $galleryCategory->delete();

        Flash::success('Gallery Category deleted successfully.');

        return redirect(route('admin.galleryCategories.index'));
    }
}
