<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Student;
use Illuminate\Http\Request;
use Image;
use DB;


use Illuminate\Support\Facades\Hash;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;


class StudentController extends Controller
{



    public function store(Request $request){
        $request->validate([
           
            'username' => 'required|unique:students,username',
            'email' => 'required|unique:students,email',
            'password' => 'required',
            // 'g_photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048'
       ],
       [
        // 'image.image64' => 'File must be an image of jpeg,png,gif'
       ]);

       try {
            DB::beginTransaction();

            $student = new Student;
            $student->username = $request->username;
            $student->password = bcrypt($request->password);
            $student->name = $request->name;
            $student->degree = $request->degree;
            $student->major = $request->major;
            $student->nuc = $request->nuc;
            $student->gyear = $request->gyear;

            $student->g_photo = $student->uploadFile($field = 'g_photo', $save_title=$request->name, $path=null);

            $student->award_status = $request->award_status;
            $student->awname = $request->awname;
            $student->awtime = $request->awtime;
            $student->awcertificate = $request->awcertificate;
            $student->occupation = $request->occupation;
            $student->workplace = $request->workplace;
            $student->address = $request->address;
            $student->email = $request->email;
            $student->phone = $request->phone;
            $student->wechat = $request->wechat;
            $student->message = $request->message;

            $student->gender = $request->gender; // new

            $student->user_type = $request->user_type;
            $student->status = 1;
            $student->save();

            DB::commit();

            return response()->json(['status' => 'success', 'message' => 'We have got your registration request successfully']);
       }
       catch( \Execption $e ) {
            // return $e;
            DB::rollBack();
            return response()->json(['status' => 'error', 'message' => 'Something wrong']);
       }


    }
}
