<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Resources\JobResource;

class JobController extends Controller
{
    public function get_jobs(){

        $jobs = new \App\Models\Job;

        if(request('position')){
            $jobs = $jobs->where( 'position', 'like', '%' . request('position') . '%');
        }

        if(request('company')){
            $jobs = $jobs->where( 'cmp_name', 'like', '%' . request('company') . '%');
        }

        if(request('location')){
            $jobs = $jobs->where( 'cmp_location', 'like', '%' . request('location') . '%');
        }

        if($rates = request('rate')){
            $rate_arr = explode('-', $rates);
            $rate_min = $rate_arr[0];
            $rate_max = $rate_arr[1];

            $jobs = $jobs->whereBetween('salary', [$rate_min, $rate_max]);
        }


        $jobs = $jobs->active()->paginate(10);
        return JobResource::collection($jobs);
    }

    public function show($id){
        $jobs = \App\Models\Job::find($id);
        return new JobResource($jobs);
    }

    public function get_job_lead(){
        $job = \App\Models\Job::latest()->first();
        return new JobResource($job);
    }

    public function subscribe_job($job_id){

        if(!$job_id){
            return response()->json(['errors' => ['root' => 'Job ID not found']], 401);
        }

        $check_if_already_subscribed = \App\Models\JobSubscriber::where('student_id', auth('api')->user()->id)->where('job_id', $job_id)->first();

        if($check_if_already_subscribed){
            return response()->json(['errors' => ['root' => 'You already subscribed this job']], 401);
        }

        $create_job = \App\Models\JobSubscriber::create([
            'job_id' => $job_id,
            'student_id' => auth('api')->user()->id,
            'name' => auth('api')->user()->name,
            'address' => auth('api')->user()->address,
            'email' => auth('api')->user()->email,
            'phone' => auth('api')->user()->phone,
            'status' => 1,
        ]);

        return response()->json(['status' => 'success', 'message' => 'You have sucessfully subscribed this job. Thankyou'], 200);

    }
}
