<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Registration | Naba Al Quran Academy </title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <!-- Ionicons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">

    <!-- Theme style -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.3/css/AdminLTE.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.3/css/skins/_all-skins.min.css">

    <!-- iCheck -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/skins/square/_all.css">

    <link rel="stylesheet" href="<?php echo e(asset('css/admin-style.css')); ?>">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body class="hold-transition register-page">
<div class="register-box">
    <div class="register-logo">
        <a href="<?php echo e(url('/home')); ?>"><b>Registration </b></a>
    </div>

    <div class="register-box-body">
        <p class="login-box-msg">Register a new membership</p>

        <?php echo $__env->make('components.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form method="post" action="<?php echo e(action('StudentController@register')); ?>">
            <?php echo csrf_field(); ?>

            <div class="row">
                <!-- Name Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('name', 'Name:'); ?>

                    <?php echo Form::text('name', null, ['class' => 'form-control']); ?>

                </div>

                <!-- Date Of Birth Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('date_of_birth', 'Date Of Birth:'); ?>

                    <?php echo Form::date('date_of_birth', null, ['class' => 'form-control','id'=>'date_of_birth']); ?>

                </div>

                <?php $__env->startPush('scripts'); ?>
                    <script type="text/javascript">
                        $('#date_of_birth').datetimepicker({
                            format: 'YYYY-MM-DD HH:mm:ss',
                            useCurrent: false
                        })
                    </script>
                <?php $__env->stopPush(); ?>

                <!-- Email Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('email', 'Email:'); ?>

                    <?php echo Form::email('email', null, ['class' => 'form-control']); ?>

                </div>

                <!-- Password Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('password', 'Password:'); ?>

                    <?php echo Form::password('password', ['class' => 'form-control']); ?>

                </div>

                

                <!-- Father Name Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('father_name', 'Father Name:'); ?>

                    <?php echo Form::text('father_name', null, ['class' => 'form-control']); ?>

                </div>

                <!-- Mother Name Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('mother_name', 'Mother Name:'); ?>

                    <?php echo Form::text('mother_name', null, ['class' => 'form-control']); ?>

                </div>

                <!-- Gender Field -->
                <div class="form-group col-sm-12">
                    <?php echo Form::label('gender', 'Gender:'); ?>

                    <label class="radio-inline">
                        <?php echo Form::radio('gender', "Male", null); ?> Male
                    </label>

                    <label class="radio-inline">
                        <?php echo Form::radio('gender', "Female", null); ?> Female
                    </label>

                </div>

                <!-- Country Id Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('country_id', 'Country:'); ?>

                    <?php echo Form::select('country_id', \App\Models\Country::pluck('name', 'id'), null, ['class' => 'form-control']); ?>

                </div>

                <!-- Address Field -->
                <div class="form-group col-sm-12 col-lg-12">
                    <?php echo Form::label('address', 'Address:'); ?>

                    <?php echo Form::textarea('address', null, ['class' => 'form-control']); ?>

                </div>

                <!-- Student Type Field -->
                <div class="form-group col-sm-12">
                    <?php echo Form::label('student_type', 'Student Type:'); ?>

                    <label class="radio-inline">
                        <?php echo Form::radio('student_type', "adults", null); ?> Adult
                    </label>

                    <label class="radio-inline">
                        <?php echo Form::radio('student_type', "kids", null); ?> Kids
                    </label>

                </div>

                <!-- Phone Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('phone', 'Phone:'); ?>

                    <?php echo Form::number('phone', null, ['class' => 'form-control']); ?>

                </div>

                <!-- Home Phone Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('home_phone', 'Home Phone:'); ?>

                    <?php echo Form::number('home_phone', null, ['class' => 'form-control']); ?>

                </div>

                <!-- 'bootstrap / Toggle Switch Sms Notify Field' -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('sms_notify', 'Sms Notify:'); ?>

                    <label class="checkbox-inline">
                        <?php echo Form::hidden('sms_notify', 0); ?>

                        <?php echo Form::checkbox('sms_notify', 1, null,  ['data-toggle' => 'toggle']); ?>

                    </label>
                </div>


                

                <!-- Skype Id Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('skype_id', 'Skype Id:'); ?>

                    <?php echo Form::text('skype_id', null, ['class' => 'form-control']); ?>

                </div>

                <!-- Zoom Id Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('zoom_id', 'Zoom Id:'); ?>

                    <?php echo Form::text('zoom_id', null, ['class' => 'form-control']); ?>

                </div>

                

            </div>

            <div class="row">
                <div class="col-xs-8">
                    <div class="checkbox icheck">
                        <label>
                            <input type="checkbox"> I agree to the <a href="#">terms</a>
                        </label>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-xs-4">
                    <button type="submit" class="btn btn-primary btn-block btn-flat">Register</button>
                </div>
                <!-- /.col -->
            </div>
        </form>

        <a href="<?php echo e(url('/login')); ?>" class="text-center">I already have a membership</a>
    </div>
    <!-- /.form-box -->
</div>
<!-- /.register-box -->

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

<!-- AdminLTE App -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.3/js/adminlte.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js"></script>

<script>
    $(function () {
        $('input').iCheck({
            checkboxClass: 'icheckbox_square-blue',
            radioClass: 'iradio_square-blue',
            increaseArea: '20%' // optional
        });
    });
</script>
</body>
</html>
<?php /**PATH /home/abcalumn/public_html/admin/resources/views/auth/register.blade.php ENDPATH**/ ?>