<div class="table-responsive">
    <table class="table" id="galleries-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Category</th>
                <th>Title</th>
                <th>Image</th>
                <th>Status</th>
                <th colspan="3">Action</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($gallery->id); ?></td>
                <td><?php if($gallery->category): ?><?php echo e($gallery->category->name); ?><?php endif; ?></td>
                <td><?php echo e($gallery->title); ?></td>
                <td><?php echo $gallery->imageToShow('image'); ?></td>
                <td><?php echo $gallery->status_buttons(); ?></td>
                <td>
                    <?php echo Form::open(['route' => ['admin.galleries.destroy', $gallery->id], 'method' => 'delete']); ?>

                    <div class='btn-group'>
                        <a href="<?php echo e(route('admin.galleries.show', [$gallery->id])); ?>" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-eye-open"></i></a>
                        <a href="<?php echo e(route('admin.galleries.edit', [$gallery->id])); ?>" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-edit"></i></a>
                        <?php echo Form::button('<i class="glyphicon glyphicon-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'onclick' => "return confirm('Are you sure?')"]); ?>

                    </div>
                    <?php echo Form::close(); ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/abcalumn/public_html/admin/resources/views/admin/galleries/table.blade.php ENDPATH**/ ?>