<div class="table-responsive">
    <table class="table" id="blogCategories-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
        <th>Status</th>
                <th colspan="3">Action</th>
            </tr>
        </thead>
        <tbody>
        @foreach($blogCategories as $blogCategory)
            <tr>
                <td>{{$blogCategory->id}}</td>
                <td>{{ $blogCategory->name }}</td>
                <td>{!! $blogCategory->status_buttons() !!}</td>
                <td>
                    {!! Form::open(['route' => ['admin.blogCategories.destroy', $blogCategory->id], 'method' => 'delete']) !!}
                    <div class='btn-group'>
                        <a href="{{ route('admin.blogCategories.show', [$blogCategory->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-eye-open"></i></a>
                        <a href="{{ route('admin.blogCategories.edit', [$blogCategory->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-edit"></i></a>
                        {!! Form::button('<i class="glyphicon glyphicon-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'onclick' => "return confirm('Are you sure?')"]) !!}
                    </div>
                    {!! Form::close() !!}
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>
