<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('username', 191)->unique()->nullable();
            $table->string('email', 191)->unique()->nullable();
            $table->text('password');
            $table->string('name', 191)->nullable();
            $table->string('degree', 191)->nullable();
            $table->string('major', 300)->nullable();
            $table->string('nuc', 300)->nullable()->comment('univercity name');
            $table->string('gyear', 191)->nullable();

            //new
            $table->string('g_photo', 191)->nullable()->comment('graduation photo');
            $table->string('p_photo', 191)->nullable()->comment('Profile photo');

            $table->string('award_status', 191)->nullable();
            
            $table->text('awname')->nullable();
            $table->dateTime('awtime')->nullable();
            $table->string('awcertificate', 300)->nullable();

            $table->string('occupation', 300)->nullable();
            $table->string('workplace', 300)->nullable();
            $table->string('address', 300)->nullable();
            $table->string('phone', 191)->nullable();
            $table->string('wechat', 191)->nullable();
            $table->text('message', 500)->nullable();

            //new
            $table->string('gender', 191)->nullable();
            
            $table->string('reset_token', 191)->nullable();
            $table->string('reset_token_expire_in_min', 191)->nullable();
            $table->string('update_request', 191)->nullable();

            $table->string('user_type', 191)->nullable();
            $table->integer('status')->nullable();
            $table->timestamps();
        });


        $file = realpath(__DIR__.'/../catalogs/students.sql');
        DB::unprepared( file_get_contents($file) );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('students');
    }
}
