<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class StudentAward
 * @package App\Models
 * @version April 23, 2021, 6:53 am UTC
 *
 * @property \App\Models\Student student
 * @property integer student_id
 * @property string awname
 * @property string awtime
 * @property string awcertificate
 * @property integer status
 */
class StudentAward extends Model
{

    public $table = 'student_awards';
    




    public $upload_path = 'uploads/awcertificate/';

    public $search_fields = [
        'student_id',
        'awname',
        'awtime',
        'awcertificate',
        'status'
    ];
    public $fillable = [
        'student_id',
        'awname',
        'awtime',
        'awcertificate',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'student_id' => 'integer',
        'awname' => 'string',
        'awtime' => 'string',
        'awcertificate' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function student()
    {
        return $this->belongsTo(\App\Models\Student::class, 'student_id', 'id');
    }
}
