<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Member
 * @package App\Models
 * @version March 29, 2021, 7:50 am UTC
 *
 * @property \App\Models\MemberCategory category
 * @property integer category_id
 * @property string name
 * @property string profession
 * @property string company_name
 * @property string image
 * @property string description
 * @property string body
 * @property integer status
 */
class Member extends Model
{

    public $table = 'members';
    




    public $upload_path = 'uploads/members';

    public $search_fields = [
        'category_id',
        'name',
        'email',
        'profession',
        'company_name',
        'image',
        'description',
        'body',
        'status'
    ];


    public $fillable = [
        'category_id',
        'name',
        'email',
        'profession',
        'company_name',
        'image',
        'description',
        'body',
        'social_facebook',
        'social_twitter',
        'social_linkedin',
        'social_wechat',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'category_id' => 'integer',
        'name' => 'string',
        'email' => 'string',
        'profession' => 'string',
        'company_name' => 'string',
        'image' => 'string',
        'description' => 'string',
        'body' => 'string',
        'social_facebook' => 'string',
        'social_twitter' => 'string',
        'social_linkedin' => 'string',
        'social_wechat' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'category_id' => 'required',
        'name' => 'required',
        'image' => 'image|mimes:jpeg,png,jpg|max:2048'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function category()
    {
        return $this->belongsTo(\App\Models\MemberCategory::class, 'category_id', 'id');
    }
}
