<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class JobSubscriber
 * @package App\Models
 * @version April 6, 2021, 8:38 am UTC
 *
 * @property \App\Models\Job job
 * @property \App\Models\Student student
 * @property integer job_id
 * @property integer student_id
 * @property string name
 * @property string expected_salary
 * @property string address
 * @property string email
 * @property string phone
 * @property integer status
 */
class JobSubscriber extends Model
{

    public $table = 'job_subscribers';

    public $upload_path = 'uploads/job_subscribers';

    public $search_fields = [
        'job_id',
        'student_id',
        'name',
        'expected_salary',
        'address',
        'email',
        'phone',
        'cv',
        'status'
    ];
    public $fillable = [
        'job_id',
        'student_id',
        'name',
        'expected_salary',
        'address',
        'email',
        'phone',
        'cv',
        'status'
        
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'job_id' => 'integer',
        'student_id' => 'integer',
        'name' => 'string',
        'expected_salary' => 'string',
        'address' => 'string',
        'email' => 'string',
        'phone' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
        'email' => 'required',
        'phone' => 'required'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function job()
    {
        return $this->belongsTo(\App\Models\Job::class, 'job_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function student()
    {
        return $this->belongsTo(\App\Models\Student::class, 'student_id', 'id');
    }
}
