<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Job
 * @package App\Models
 * @version March 23, 2021, 12:44 pm UTC
 *
 * @property string title
 * @property integer salary
 * @property integer salary_negotialble
 * @property string position
 * @property string description
 * @property string description_additional
 * @property string|\Carbon\Carbon dead_line
 * @property string cmp_website
 * @property string cmp_image
 * @property string cmp_description
 * @property string cmp_location
 * @property integer completed
 * @property integer status
 */
class Job extends Model
{

    public $table = 'jobs';
    




    public $upload_path = 'uploads/jobs';

    public $search_fields = [
        'title',
        'salary',
        'salary_negotialble',
        'position',
        'description',
        'description_additional',
        'dead_line',
        'cmp_name',
        'cmp_website',
        'cmp_image',
        // 'cv',
        'cmp_description',
        'cmp_location',
        'completed',
        'status'
    ];
    public $fillable = [
        'title',
        'salary',
        'salary_negotialble',
        'position',
        'description',
        'description_additional',
        'dead_line',
        'cmp_name',
        'cmp_website',
        'cmp_image',
        // 'cv',
        'cmp_description',
        'cmp_location',
        'completed',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'title' => 'string',
        'salary' => 'integer',
        'salary_negotialble' => 'integer',
        'position' => 'string',
        'description' => 'string',
        'description_additional' => 'string',
        'dead_line' => 'datetime',
        'cmp_name' => 'string',
        'cmp_website' => 'string',
        'cmp_image' => 'string',
        // 'cv' => 'string',
        'cmp_description' => 'string',
        'cmp_location' => 'string',
        'completed' => 'integer',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'cmp_name' => 'required',
        'salary' => 'required',
        'position' => 'required',
        'cmp_image' => 'image|mimes:jpeg,png,jpg|max:2048',
        // 'cv' => 'image|mimes:jpeg,png,jpg,pdf,doc|max:5120'
    ];

    
}
