<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Gallery
 * @package App\Models
 * @version March 21, 2021, 12:16 pm UTC
 *
 * @property \App\Models\GalleryCategory caregory
 * @property integer category_id
 * @property string title
 * @property string image
 * @property string description
 * @property integer status
 */
class Gallery extends Model
{

    public $table = 'galleries';

    public $upload_path = 'uploads/galleries';

    public $search_fields = [
        'category_id',
        'title',
        'image',
        'description',
        'status'
    ];
    public $fillable = [
        'category_id',
        'title',
        'image',
        'description',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'category_id' => 'integer',
        'title' => 'string',
        'image' => 'string',
        'description' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'category_id' => 'required',
        'title' => 'required',
        'image' => 'image|mimes:jpeg,png,jpg|max:2048'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function category()
    {
        return $this->belongsTo(\App\Models\GalleryCategory::class, 'category_id', 'id');
    }
}
