<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class ExamQuestion
 * @package App\Models
 * @version May 25, 2021, 12:12 pm UTC
 *
 * @property \App\Models\Exam exam
 * @property \App\Models\ExamChapter chapter
 * @property \App\Models\ExamTopic topic
 * @property integer exam_id
 * @property integer chapter_id
 * @property integer topic_id
 * @property string title
 * @property string answer
 * @property string time_limit
 * @property string position
 * @property integer status
 */
class ExamQuestion extends Model
{

    public $table = 'exam_questions';

    public $upload_path = 'uploads/exam_questions';

    public $search_fields = [
        'exam_id',
        'chapter_id',
        'topic_id',
        'title',
        'answer',
        'time_limit',
        'position',
        'status'
    ];
    public $fillable = [
        'exam_id',
        'chapter_id',
        'topic_id',
        'title',
        'answer',
        'time_limit',
        'start',
        'script',
        'script_type',
        'position',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'exam_id' => 'integer',
        'chapter_id' => 'integer',
        'topic_id' => 'integer',
        'title' => 'string',
        'answer' => 'string',
        'time_limit' => 'string',
        'start' => 'integer',
        'script' => 'integer',
        'script_type' => 'integer',
        'position' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'exam_id' => 'required',
        'chapter_id' => 'required',
        'topic_id' => 'required',
        'title' => 'required'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function exam()
    {
        return $this->belongsTo(\App\Models\Exam::class, 'exam_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function chapter()
    {
        return $this->belongsTo(\App\Models\ExamChapter::class, 'chapter_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function topic()
    {
        return $this->belongsTo(\App\Models\ExamTopic::class, 'topic_id', 'id');
    }
}
