<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Event
 * @package App\Models
 * @version March 22, 2021, 1:07 pm UTC
 *
 * @property string title
 * @property string image
 * @property string description
 * @property string location
 * @property string|\Carbon\Carbon start_date
 * @property integer status
 */
class Event extends Model
{

    public $table = 'events';

    public $upload_path = 'uploads/events';

    public $search_fields = [
        'title',
        'image',
        'description',
        'location',
        'start_date',
        'end_date',
        'completed',
        'status'
    ];
    public $fillable = [
        'title',
        'image',
        'description',
        'location',
        'start_date',
        'end_date',
        'completed',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'title' => 'string',
        'image' => 'string',
        'description' => 'string',
        'location' => 'string',
        'start_date' => 'datetime',
        'end_date' => 'datetime',
        'completed' => 'integer',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'title' => 'required',
        'image' => 'image|mimes:jpeg,png,jpg|max:2048',
        'start_date' => 'required',
        'end_date' => 'required'
    ];

    
}
