<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class JobResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $job = new \App\Models\Job;
        $array =  parent::toArray($request);
        $array['cmp_image_src'] = url('/') . '/' . $job->upload_path . '/' . $this->cmp_image;
        $array['short_description'] = \Illuminate\Support\Str::limit(strip_tags($this->description), $limit = 250, $end = '...');
        $array['dead_line_formatted'] = formated_date($this->dead_line);
        $array['deal_line_html5'] = date('Y-m-d', strtotime($this->dead_line));


        return $array;
    }
}
