<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\Blog;

class BlogResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $blog = new Blog;
        $array =  parent::toArray($request);
        $array['category'] = $this->category;
        $array['image_src'] = url('/') . '/' . $blog->upload_path . '/' . $this->image;

        $array['short_description'] = \Illuminate\Support\Str::limit(strip_tags($this->description), $limit = 250, $end = '...');

        $array['formatted_date'] = formated_date($this->created_at);
        $array['created_by_name'] = $this->user ? $this->user->name : '';
        return $array;
    }
}
