<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateNoticeRequest;
use App\Http\Requests\UpdateNoticeRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\Notice;
use Illuminate\Http\Request;
use Flash;
use Response;

class NoticeController extends AppBaseController
{
    /**
     * Display a listing of the Notice.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var Notice $notices */
        $notices = Notice::withSearch()->latest()->paginate(10);

        return view('admin.notices.index')
            ->with('notices', $notices);
    }

    /**
     * Show the form for creating a new Notice.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.notices.create');
    }

    /**
     * Store a newly created Notice in storage.
     *
     * @param CreateNoticeRequest $request
     *
     * @return Response
     */
    public function store(CreateNoticeRequest $request, Notice $notice)
    {
        $input = $request->all();
        $input['image'] = $notice->uploadFile($field = 'image', $save_title=$request->title, $path=null);
        /** @var Notice $notice */
        $notice = Notice::create($input);

        Flash::success('Notice saved successfully.');

        return redirect(route('admin.notices.index'));
    }

    /**
     * Display the specified Notice.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var Notice $notice */
        $notice = Notice::find($id);

        if (empty($notice)) {
            Flash::error('Notice not found');

            return redirect(route('admin.notices.index'));
        }

        return view('admin.notices.show')->with('notice', $notice);
    }

    /**
     * Show the form for editing the specified Notice.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var Notice $notice */
        $notice = Notice::find($id);

        if (empty($notice)) {
            Flash::error('Notice not found');

            return redirect(route('admin.notices.index'));
        }

        return view('admin.notices.edit')->with('notice', $notice);
    }

    /**
     * Update the specified Notice in storage.
     *
     * @param int $id
     * @param UpdateNoticeRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateNoticeRequest $request)
    {
        /** @var Notice $notice */
        $notice = Notice::find($id);

        if (empty($notice)) {
            Flash::error('Notice not found');

            return redirect(route('admin.notices.index'));
        }

        $notice->fill($request->all());
        $notice->image = $notice->delete_existing_and_upload_file($field = 'image', $save_title=$request->name, $path=null);
        $notice->save();

        Flash::success('Notice updated successfully.');

        return redirect(route('admin.notices.index'));
    }

    /**
     * Remove the specified Notice from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var Notice $notice */
        $notice = Notice::find($id);

        if (empty($notice)) {
            Flash::error('Notice not found');

            return redirect(route('admin.notices.index'));
        }

        
        $notice->deleteImage('image');
        $notice->delete();

        Flash::success('Notice deleted successfully.');

        return redirect(route('admin.notices.index'));
    }
}
