<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateEventSubscriberRequest;
use App\Http\Requests\UpdateEventSubscriberRequest;
use App\Http\Controllers\AppBaseController;
use App\Models\EventSubscriber;
use Illuminate\Http\Request;
use Flash;
use Response;

class EventSubscriberController extends AppBaseController
{
    /**
     * Display a listing of the EventSubscriber.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        /** @var EventSubscriber $eventSubscribers */
        $eventSubscribers = EventSubscriber::withSearch()->latest()->paginate(10);

        return view('admin.event_subscribers.index')
            ->with('eventSubscribers', $eventSubscribers);
    }

    /**
     * Show the form for creating a new EventSubscriber.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.event_subscribers.create');
    }

    /**
     * Store a newly created EventSubscriber in storage.
     *
     * @param CreateEventSubscriberRequest $request
     *
     * @return Response
     */
    public function store(CreateEventSubscriberRequest $request)
    {
        $input = $request->all();

        /** @var EventSubscriber $eventSubscriber */
        $eventSubscriber = EventSubscriber::create($input);

        Flash::success('Event Subscriber saved successfully.');

        return redirect(route('admin.eventSubscribers.index'));
    }

    /**
     * Display the specified EventSubscriber.
     *
     * @param int $id
     *
     * @return Response
     */
    public function show($id)
    {
        /** @var EventSubscriber $eventSubscriber */
        $eventSubscriber = EventSubscriber::find($id);

        if (empty($eventSubscriber)) {
            Flash::error('Event Subscriber not found');

            return redirect(route('admin.eventSubscribers.index'));
        }

        return view('admin.event_subscribers.show')->with('eventSubscriber', $eventSubscriber);
    }

    /**
     * Show the form for editing the specified EventSubscriber.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        /** @var EventSubscriber $eventSubscriber */
        $eventSubscriber = EventSubscriber::find($id);

        if (empty($eventSubscriber)) {
            Flash::error('Event Subscriber not found');

            return redirect(route('admin.eventSubscribers.index'));
        }

        return view('admin.event_subscribers.edit')->with('eventSubscriber', $eventSubscriber);
    }

    /**
     * Update the specified EventSubscriber in storage.
     *
     * @param int $id
     * @param UpdateEventSubscriberRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateEventSubscriberRequest $request)
    {
        /** @var EventSubscriber $eventSubscriber */
        $eventSubscriber = EventSubscriber::find($id);

        if (empty($eventSubscriber)) {
            Flash::error('Event Subscriber not found');

            return redirect(route('admin.eventSubscribers.index'));
        }

        $eventSubscriber->fill($request->all());
        $eventSubscriber->save();

        Flash::success('Event Subscriber updated successfully.');

        return redirect(route('admin.eventSubscribers.index'));
    }

    /**
     * Remove the specified EventSubscriber from storage.
     *
     * @param int $id
     *
     * @throws \Exception
     *
     * @return Response
     */
    public function destroy($id)
    {
        /** @var EventSubscriber $eventSubscriber */
        $eventSubscriber = EventSubscriber::find($id);

        if (empty($eventSubscriber)) {
            Flash::error('Event Subscriber not found');

            return redirect(route('admin.eventSubscribers.index'));
        }

        $eventSubscriber->delete();

        Flash::success('Event Subscriber deleted successfully.');

        return redirect(route('admin.eventSubscribers.index'));
    }
}
