<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Resources\SliderResource;
use App\Http\Resources\GalleryResource;
use App\Http\Resources\MemberCategoryResource;
use App\Http\Resources\NoticeResource;
use App\Http\Resources\TestimonialResource;
use App\Http\Resources\PageResource;
use App\Http\Resources\PublicationResource;

use Illuminate\Support\Facades\Validator;

class MainController extends Controller
{
    public function open() 
    {
        $data = "This data is open and can be accessed without the client being authenticated";
        return response()->json(compact('data'),200);

    }

    public function page_show($id){
        $page = \App\Page::find($id);
        return new PageResource($page);
    }

    public function closed() 
    {
        $data = "Only authorized users can see this";
        return response()->json(compact('data'),200);
    }

    
    public function get_slider(){
        $sliders = \App\Models\Slider::active()->get();
        return SliderResource::collection($sliders);
    }

    public function get_gallery_publications(){
        $publications = \App\Models\Gallery::active()->limit(6)->where('category_id', 1)->orderBy('id','desc')->get();
        return GalleryResource::collection($publications);
    }

    public function get_testimonials(){
        $testimonials = \App\Models\Testimonial::active()->get();
        return TestimonialResource::collection($testimonials);
    }

    public function get_publications(){
        $publications = \App\Models\Publication::active()->get();
        return PublicationResource::collection($publications);
    }

    public function get_gallery(){
        $galleries = \App\Models\Gallery::active()->orderBy('id','desc')->get();
        return GalleryResource::collection($galleries);
    }

    public function get_gallery_by_category($category_id){
        $category = \App\Models\GalleryCategory::find($category_id);
        $galleries = \App\Models\Gallery::where('category_id', $category_id)->active()->get();
        

        return GalleryResource::collection($galleries)->additional([
            'category' => $category
        ]);;
    }

    public function get_member_categories(){
        $member_categories = \App\Models\MemberCategory::active()->get();
        return MemberCategoryResource::collection($member_categories);
    }

    public function store_newsletter(Request $request){
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|email|max:255|unique:newsletters',
        ]);

        if($validator->fails()){
            return response()->json($validator->errors(), 400);
        }

        $newsletter = \App\Models\Newsletter::create([
            'email' => request('email'),
            'status' => 1,
        ]);

        return response()->json(['status' => 'success', 'message' => 'We have got your email successfully']);
    }

    public function contact_store(Request $request){
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'subject' => 'required',
            'email' => 'required|string|email|max:255',
            'message' => 'required',
        ]);

        if($validator->fails()){
            return response()->json($validator->errors(), 400);
        }

        $newsletter = \App\Models\Contact::create([
            'name' => request('name'),
            'email' => request('email'),
            'subject' => request('subject'),
            'message' => request('message'),
            'status' => 1,
        ]);

        \App\Models\Email::notify_contact_details_to_admin($newsletter);

        return response()->json(['status' => 'success', 'message' => 'We have got your contact Info Successfully']);
    }

    public function get_notices(){
        $notices = \App\Models\Notice::latest()->active()->get();
        return NoticeResource::collection($notices);
    }

    public function get_notice($id){
        $notice = \App\Models\Notice::find($id);
        return new NoticeResource($notice);
    }

}
