<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Resources\EventResource;

class EventController extends Controller
{
    public function get_events(){
        $events = \App\Models\Event::orderBy('end_date','desc')->active()->paginate(6);
        return EventResource::collection($events);
    }

    public function show($id){
        $events = \App\Models\Event::find($id);
        return new EventResource($events);
    }

    public function get_event_lead(){
        $event = \App\Models\Event::latest()->where('completed', '!=' , 1)->get()->first();
        if($event){
            return new EventResource($event);
        }
        return [];
    }

    public function join_event(){
        $event = \App\Models\Event::latest()->first();
        return new EventResource($event);
    }

    public function subscribe_event($event_id){

        if(!$event_id){
            return response()->json(['errors' => ['root' => 'Event ID not found']], 401);
        }

        $check_if_already_subscribed = \App\Models\EventSubscriber::where('student_id', auth('api')->user()->id)->where('event_id', $event_id)->first();

        if($check_if_already_subscribed){
            return response()->json(['errors' => ['root' => 'You already subscribed this event']], 401);
        }

        $newsletter = \App\Models\EventSubscriber::create([
            'event_id' => $event_id,
            'student_id' => auth('api')->user()->id,
            'name' => auth('api')->user()->name,
            'address' => auth('api')->user()->address,
            'email' => auth('api')->user()->email,
            'phone' => auth('api')->user()->phone,
            'status' => 1,
        ]);

        return response()->json(['status' => 'success', 'message' => 'You have sucessfully subscribed this event. Thankyou'], 200);

    }




}
