<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Resources\BlogResource;

class BlogController extends Controller
{
    public function get_blogs(){
        $blogs = \App\Models\Blog::orderBy('id','desc')->active()->latest()->paginate(6);
        $blogsCount = \App\Models\Blog::active()->latest()->get();
        return BlogResource::collection($blogs)->additional(['totalNews' => $blogsCount->count()]);
    }


    public function get_category_blogs($cat_id){
        // return response()->json($cat_id);
        $category = \App\Models\BlogCategory::find($cat_id);
        $blogs = \App\Models\Blog::where('category_id', $cat_id)->active()->latest()->paginate(10);
        // return BlogResource::collection($blogs);
        return BlogResource::collection($blogs)->additional(['category' => $category]);
    }

    

    public function show($id){
        $blogs = \App\Models\Blog::find($id);
        return new BlogResource($blogs);
    }

    public function get_popular_blog(){
        $blogs = \App\Models\Blog::active()->latest()->limit(5)->get();
        return BlogResource::collection($blogs);
    }

    public function get_popular_category(){
        $blogsCategory = \App\Models\BlogCategory::active()->latest()->limit(10)->get();
        return $blogsCategory;
    }

    
    public function get_home_blog(){
        $blogs = \App\Models\Blog::active()->latest()->limit(6)->get();
        return BlogResource::collection($blogs);
    }



}
