<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Student;
use App\Models\Email;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\StudentResource;
use DB;
use Carbon\Carbon;
use Mail;

class AuthController extends Controller
{

	public function forgot_password(Request $request){
        $exp_minutes = 10;
        $student = Student::where('email', '=', $request->email)
            ->first();
        //Check if the student exists
        if (!$student) {
            return response()->json(['errors' => ['root' => 'Email not exists']], 401);
        }

        $student->reset_token = rand(1000,9999);
        $student->reset_token_expire_in_min = Carbon::now()->addMinutes($exp_minutes)->timestamp;
        $student->save();


        if (Email::send_forgot_password_email($student)) {
            return response()->json(['status' => 'success', 'message' => 'A reset link has been sent to your email address.']);
        } else {
            return response()->json(['errors' => ['root' => 'Something is wrong']], 401);
        }
    }

    public function change_password(Request $request){
        // return response()->json($request->all());

        $request->validate([

            'email' => 'required|exists:students',
            'reset_token' => 'required|exists:students',
            'password' => 'min:4|required_with:password_confirmation|same:password_confirmation',
            'password_confirmation' => 'min:4'
       ],
       [
       ]);



       try {
            DB::beginTransaction();
            $student = Student::where('email', $request->email)->where('reset_token', $request->reset_token)->get()->first();
            $student->password = bcrypt($request->password);
            $student->save();


            DB::commit();
            // DB::rollBack();

            return response()->json(['status' => 'success', 'message' => 'Password Updated. You can login..']);
       }
       catch( \Execption $e ) {
            DB::rollBack();

            return response()->json(['status' => 'error', 'message' => 'Something wrong']);
       }
    }

	public function update_profile(Request $request){

		if(!$student = auth('api')->user()){
			 return response()->json(['errors' => ['root' => 'User not logged in']], 401);
		}

		$request->validate([
           
            // 'username' => 'required|unique:students,username',
            // 'email' => 'required|unique:students,email',

            // 'password' => 'required',
            'name' => 'required',
            'degree' => 'required',
            'major' => 'required',
            'nuc' => 'required',
            'gyear' => 'required',

            // 'g_photo'  => 'mimes:jpeg,png,pdf|max:2048',
            // 'p_photo'  => 'mimes:jpeg,png,pdf|max:2048',
            
            'award_status' => 'required',
            'occupation' => 'required',
            'workplace' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'wechat' => 'required',
            'gender' => 'required',
            'message' => 'required',
        ],
       [
       ]);



       try {
            DB::beginTransaction();

            // $student->username = $request->username;
            // return response()->json($request->all());
            if($student->password){
	            $student->password = bcrypt($request->password);
            }
            $student->name = $request->name;
            $student->degree = $request->degree;
            $student->major = $request->major;
            $student->nuc = $request->nuc;
            $student->gyear = $request->gyear;

            if($request->p_photo && $request->hasFile('p_photo')){
                $student->p_photo  =  $student->uploadFileVue('p_photo', $student->name . '_profile', 'uploads/profile_photo/');
            }
            if($request->g_photo && $request->hasFile('g_photo')){
                $student->g_photo  =  $student->uploadFileVue('g_photo', $student->name . '_graduation', 'uploads/graduation_photo/');
            }
            $student->award_status = $request->award_status;
            $student->occupation = $request->occupation;
            $student->workplace = $request->workplace;
            $student->address = $request->address;
            $student->email = $request->email;
            $student->phone = $request->phone;
            $student->wechat = $request->wechat;
            $student->message = $request->message;

            $student->gender = $request->gender; // new

            $student->user_type = $request->user_type;
            $student->update_request = 1;// requested for update
            $student->save();

            DB::commit();
            // DB::rollBack();

            return response()->json(['status' => 'success', 'message' => 'We got your update request successfully.']);
       }
       catch( \Execption $e ) {
            DB::rollBack();

            return response()->json(['status' => 'error', 'message' => 'Something wrong']);
       }

	}
    
    public function login(Request $request){
        $validatedData = request()->validate([
	        'email' => 'required',
	        'password' => 'required',
	    ]);

        $check_active_or_not = \App\Models\Student::where('email', request('email'))->first();
        if($check_active_or_not && $check_active_or_not->status != 1){
        	 return response()->json(['errors' => ['root' => 'Your credentials not active']], 401);
        }

	    $credentials = request(['email', 'password']);

	    if (!$token = auth('api')->attempt($credentials)) {
	        return response()->json(['errors' => ['root' => 'Please check your username and password and try again!']], 401);
	    }
	    return response()->json([
			// 'success' => true,
	    	'data' => new StudentResource(auth('api')->user()),
	        'token' => $token,
	        'expires' => auth('api')->factory()->getTTL() * 60,
	    ]);


    }

 //    public function register(Request $request) {

    	
 //    	$validator = Validator::make($request->all(), [
 //                'username' => 'required|string|max:255|unique:students',
 //                'email' => 'required|string|email|max:255|unique:students',
 //                'name' => 'required|string|max:255',
 //                'password' => 'required|string|min:4',
 //        ]);

 //        if($validator->fails()){
 //            return response()->json($validator->errors(), 400);
 //        }

	//     $user = \App\Models\Student::create([
	//     	'username' => request('username'),
	//     	'email' => request('email'),
	//     	'name' => request('name'),
	//     	'password' => bcrypt(request('password')),
	//     ]);

	//     if ($token = auth('api')->login($user)) {
	//         return response()->json([
	//         	'data' => $user,
	// 	        'token' => $token,
	// 	        'expires' => auth('api')->factory()->getTTL() * 60,
	// 	    ]);
	//     }
	    
	// }

	public function me(){
		return response()->json([
			// 'success' => true,
			'data' => new StudentResource(auth('api')->user()),
		]);
	}
	
    public function logout(){
        \Auth::guard('api')->logout();
		return response()->json([
			'success' => true,
		]);
    }
}
