<?php $__env->startSection('title'); ?> Page Category <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
	<div class="row">
		<div class="col-md-12">
			<div class="panel panel-default">
				<div class="panel-heading">
					<div class="row">
						<div class="col-md-4">
							<a href="<?php echo e(action('AdminPageCategoryController@create')); ?>" class="btn btn-primary">+Add New</a>
						</div>
						<div class="col-md-3 col-md-offset-5">
							<form action="<?php echo e(action('AdminPageCategoryController@search')); ?>">
								<div class="form-group">
									<input type="text" name="keyword" class="form-control" placeholder="Search" value="<?php echo e(request('keyword') ? request('keyword') : ''); ?>">
								</div>
							</form>
						</div>
					</div>
				</div>
				<div class="panel-body btn-margins">
					<div class="col-md-12">
						<table class="table">
							<thead>
								<tr>
									<th>#</th>
									<th>Name</th>
									<th>Status</th>
									<th>Date</th>
									<th>Actions</th>
								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $page_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($category->id); ?></td>
									<td><?php echo e($category->name); ?></td>
									<td>
										<?php if($category->status): ?> 
											<button type="button" class="btn btn-sm btn-success">Active</button>
										<?php else: ?>
											<button type="button" class="btn btn-sm btn-danger">Inactive</button>
										<?php endif; ?>
									</td>
									<td><?php echo e($category->created_at->toFormattedDateString()); ?></td>
									<td>
										<a class="btn btn-primary" href="<?php echo e(action('AdminPageCategoryController@show', $category->id)); ?>">View</a>
										<a class="btn btn-primary" href="<?php echo e(action('AdminPageCategoryController@edit', $category->id)); ?>">Edit</a>
										<a class="btn btn-danger del" href="<?php echo e(action('AdminPageCategoryController@destroy', $category->id)); ?>">Delete</a>
									</td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
						<?php echo e($page_categories->appends(['keyword' => request('keyword')])->links()); ?>

					</div>
				</div>
			</div><!-- /.panel-->
		</div><!--/ col-md-12 -->
	</div><!--/ row -->
<?php $__env->stopSection(); ?>	
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/abcalumn/public_html/admin/resources/views/admin/page_categories/index.blade.php ENDPATH**/ ?>