<div class="table-responsive">
    <table class="table" id="blogs-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Title</th>
                <td>Tag</td>
                <th>Image</th>
                <th>Status</th>
                <th colspan="3">Action</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($blog->id); ?></td>
                <td><?php echo e($blog->title); ?></td>
                <td><?php if($blog->category): ?><?php echo e($blog->category->name); ?><?php endif; ?></td>
                <td><?php echo $blog->imageToShow(); ?></td>
                <td><?php echo $blog->status_buttons(); ?></td>
                <td>
                    <?php echo Form::open(['route' => ['admin.blogs.destroy', $blog->id], 'method' => 'delete']); ?>

                    <div class='btn-group'>
                        <a href="<?php echo e(route('admin.blogs.show', [$blog->id])); ?>" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-eye-open"></i></a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog-edit')): ?>
                            <a href="<?php echo e(route('admin.blogs.edit', [$blog->id])); ?>" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-edit"></i></a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog-delete')): ?>
                            <?php echo Form::button('<i class="glyphicon glyphicon-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'onclick' => "return confirm('Are you sure?')"]); ?>

                        <?php endif; ?>
                    </div>
                    <?php echo Form::close(); ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/abcalumn/public_html/admin/resources/views/admin/blogs/table.blade.php ENDPATH**/ ?>