<div class="table-responsive">
    <table class="table" id="students-table">
        <thead>
            <tr>
                <th>ID</th>
                
                <th>Email</th>
                <th>Name</th>
                
                 <th>Graduation year</th>
                 <th>Workplace</th>
                 <th>Univeristy Name</th>
                
                
                <th>Gender</th>
                
                <th>Approve</th>
                <th>Status</th>
                <?php if(\Request::is('admin/students/update-request')): ?>  
                    <th>
                        Update Request
                    </th>
                <?php endif; ?>
                <th colspan="3">Action</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($student->id); ?></td>
                
                <td><?php echo e($student->email); ?></td>
                <td><?php echo e($student->name); ?></td>
                <td><?php echo e($student->gyear); ?></td>
                <td><?php echo e($student->workplace); ?></td>
                <td><?php echo e($student->nuc); ?></td>
                
                
                
                <td><?php echo e($student->gender); ?></td>
                
                <td>
                    <?php if($student->status): ?>
                        <a href="<?php echo e(action('StudentController@decline_request', $student->id)); ?>" class='btn btn-success'>Decline</a>
                    <?php else: ?>
                       <a href="<?php echo e(action('StudentController@approve_request', $student->id)); ?>" class='btn btn-danger'>Approve</a>
                    <?php endif; ?>
                </td>
                <td>
                    <?php echo $student->status_buttons(); ?>

                </td>
                <?php if(\Request::is('admin/students/update-request')): ?>  
                    <td>
                        <a href="<?php echo e(action('StudentController@accept_update_request', $student->id)); ?>" class='btn btn-warning'>Accept</a>
                    </td>
                <?php endif; ?>
                <td>
                    <?php echo Form::open(['route' => ['admin.students.destroy', $student->id], 'method' => 'delete']); ?>

                    <div class='btn-group'>
                        <a href="<?php echo e(route('admin.students.show', [$student->id])); ?>" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-eye-open"></i></a>
                        <a href="<?php echo e(route('admin.students.edit', [$student->id])); ?>" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-edit"></i></a>
                        <?php echo Form::button('<i class="glyphicon glyphicon-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'onclick' => "return confirm('Are you sure?')"]); ?>

                    </div>
                    <?php echo Form::close(); ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH F:\xampp\htdocs\abca_back\resources\views/admin/students/table.blade.php ENDPATH**/ ?>