<!-- Title Field -->
<div class="form-group col-sm-6">
    <?php echo Form::label('title', 'Title:'); ?>

    <?php echo Form::text('title', null, ['class' => 'form-control']); ?>

</div>

<!-- Image Field -->
<div class="form-group col-sm-6">
    <?php echo Form::label('image', 'Image:'); ?>

    <?php echo Form::file('image'); ?>


    <?php if(if_its_edit_route()): ?>
        <div class="image-edit-show">
        <?php echo $event->imageToShowWithDeleteButton($model="Event", $field='image', $path='uploads/events'); ?>

        </div>
    <?php endif; ?>
    <br>
    <p class="text-danger">Event Image Standard Size: 1280 × 720 px or <br>Use aspect ratio: 16:9 </p>
</div>
<div class="clearfix"></div>

<!-- Description Field -->
<div class="form-group col-sm-12 col-lg-12">
    <?php echo Form::label('description', 'Description:'); ?>

    <?php echo Form::textarea('description', null, ['class' => 'form-control summernote']); ?>

</div>

<!-- Location Field -->
<div class="form-group col-sm-12 col-lg-12">
    <?php echo Form::label('location', 'Location:'); ?>

    <?php echo Form::textarea('location', null, ['class' => 'form-control']); ?>

</div>

<!-- Start Date Field -->
<div class="form-group col-sm-6">
    <?php echo Form::label('start_date', 'Start Date:'); ?>

    <?php echo Form::text('start_date', null, ['class' => 'form-control','id'=>'start_date']); ?>

</div>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $('#start_date').datetimepicker({
            format: 'YYYY-MM-DD HH:mm:ss',
            useCurrent: false
        })
    </script>
<?php $__env->stopPush(); ?>

<!-- 'bootstrap / Toggle Switch Status Field' -->
<div class="form-group col-sm-6">
    <?php echo Form::label('completed', 'Completed:'); ?>

    <label class="checkbox-inline">
        <?php echo Form::hidden('completed', 0); ?>

        <?php echo Form::checkbox('completed', 1, null,  ['data-toggle' => 'toggle']); ?>

    </label>
</div>


<!-- 'bootstrap / Toggle Switch Status Field' -->
<div class="form-group col-sm-6">
    <?php echo Form::label('status', 'Status:'); ?>

    <label class="checkbox-inline">
        <?php echo Form::hidden('status', 0); ?>

        <?php echo Form::checkbox('status', 1, null,  ['data-toggle' => 'toggle']); ?>

    </label>
</div>


<!-- Submit Field -->
<div class="form-group col-sm-12">
    <?php echo Form::submit('Save', ['class' => 'btn btn-primary']); ?>

    <a href="<?php echo e(route('admin.events.index')); ?>" class="btn btn-default">Cancel</a>
</div>
<?php /**PATH /home/abcalumn/public_html/admin/resources/views/admin/events/fields.blade.php ENDPATH**/ ?>