<?php
use App\Http\Controllers\SslCommerzPaymentController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/clear', function(){
    //session()->flush();
    \Artisan::call('cache:clear');
    // \Artisan::call('route:cache');
    \Artisan::call('view:clear');
    \Artisan::call('config:clear');
    \App\Setting::flushCache();
    echo "session cleared";
});

Route::get('/jwt', function(){
    \Artisan::call('jwt:secret');
});


Route::get('/test-email', function(){
    \App\Models\Email::send_email();
});

Route::get('/old-to-new', 'StudentController@old_to_new');



// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', 'WebController@home');
// Route::post('/access_info_proceed', 'AccessPaymentController@proceedToSsl');
// Route::post('/access_info_proceed/success', 'AccessPaymentController@success');
// Route::post('/access_info_proceed/cancel', 'AccessPaymentController@cancel');
// Route::post('/access_info_proceed/fail', 'AccessPaymentController@fail');


// // SSLCOMMERZ Start
// Route::get('/example1', [SslCommerzPaymentController::class, 'exampleEasyCheckout']);
// Route::get('/example2', [SslCommerzPaymentController::class, 'exampleHostedCheckout']);

// Route::post('/pay', [SslCommerzPaymentController::class, 'index']);
// Route::post('/pay-via-ajax', [SslCommerzPaymentController::class, 'payViaAjax']);

// Route::post('/success', [SslCommerzPaymentController::class, 'success']);
// Route::post('/fail', [SslCommerzPaymentController::class, 'fail']);
// Route::post('/cancel', [SslCommerzPaymentController::class, 'cancel']);


// Route::post('/access_payment_success', [SslCommerzPaymentController::class, 'success']);
// Route::post('/access_payment_fail', [SslCommerzPaymentController::class, 'fail']);
// Route::post('/access_payment_cancel', [SslCommerzPaymentController::class, 'cancel']);

// Route::post('/ipn', [SslCommerzPaymentController::class, 'ipn']);
//SSLCOMMERZ END


/** PAGE DYNAMIC **/
// Route::get('/pages/{page}', 'WebController@page_show');

// Route::get('/blogs', 'WebController@blogs');
// Route::get('/blog/{id}', 'WebController@blog_show');

// //Paypal
// Route::get('pay', 'PayPalController@pay')->name('pay');
// Route::get('/package/pay/{package_id}', 'PackageController@pay');

// Route::get('payment', 'PayPalController@payment')->name('payment');
// Route::get('cancel', 'PayPalController@cancel')->name('payment.cancel');
// Route::get('payment/success', 'PayPalController@success')->name('payment.success');


// Route::get('/courses', 'WebController@courses');


// Route::get('student/register', 'WebController@student_register');
// Route::post('student/register', 'WebController@student_register_store');



Auth::routes(['verify' => true]);

Route::get('/home', 'HomeController@index')->middleware('verified');

Route::group(['middleware' => ['auth']], function () {
    Route::resource('users', 'UserController');
    Route::get('profile', 'UserController@editProfile');
    Route::post('update-profile', 'UserController@updateProfile');
});
Auth::routes();
Auth::routes(['verify' => true]);
Route::get('/home', 'HomeController@index')->name('home');
// Route::get('/home', 'HomeController@index')->middleware('verified');
Route::get('/delete_image/{model}/{id}/{field}/', 'SettingController@delete_image_by_table_id_field');

Route::group(['middleware' => ['auth'], 'prefix' => 'admin'], function() {

    // Settings

    Route::get('/settings', 'AdminSettingController@index')->name('settings');
    Route::post('/settings', 'AdminSettingController@store')->name('settings.store');
    
    Route::post('/upload_summernote_photo', 'AdminSettingController@upload_summernote_photo');

    Route::get('/menus', 'AdminMenuController@index');
    Route::get('/menus/create', 'AdminMenuController@create');
    Route::get('/menus/{id}', 'AdminMenuController@show');
    Route::get('/menus/{id}/edit', 'AdminMenuController@edit');

    Route::post('menus', 'AdminMenuController@store');
    Route::put('menus/{id}', 'AdminMenuController@update');
    Route::get('menus/{id}/delete', 'AdminMenuController@destroy');


    Route::post('/save_menu_settings/{menu_id}', 'AdminMenuController@store_menu_settings');
    Route::get('/fetch_menu_settings/{menu_id}', 'AdminMenuController@fetch_menu_settings');

    // Route::get('/fetch_category/{category_id}', 'AdminBlogCategoryController@fetch_category');


    // Page

    Route::get('pages/{id}/edit', 'AdminPageController@edit');
    Route::get('pages', 'AdminPageController@index');
    Route::get('pages/search', 'AdminPageController@search');
    Route::get('pages/create', 'AdminPageController@create');
    Route::get('pages/{id}', 'AdminPageController@show');
    Route::post('pages', 'AdminPageController@store');
    Route::put('pages/{id}', 'AdminPageController@update');
    Route::get('pages/{id}/delete', 'AdminPageController@destroy');


    // Page Categories

    Route::get('page/categories/{id}/edit', 'AdminPageCategoryController@edit');
    Route::get('page/categories/', 'AdminPageCategoryController@index');
    Route::get('page/categories/search', 'AdminPageCategoryController@search');
    Route::get('page/categories/create', 'AdminPageCategoryController@create');
    Route::get('page/categories/{id}', 'AdminPageCategoryController@show');
    Route::post('page/categories/', 'AdminPageCategoryController@store');
    Route::put('page/categories/{id}', 'AdminPageCategoryController@update');
    Route::get('page/categories/{id}/delete', 'AdminPageCategoryController@destroy');



    Route::resource('users', 'UserController', ["as" => 'admin']);

    Route::get('students/update-request', 'StudentController@update_request')->name('admin.students.update_requests');

    Route::get('students/{id}/approve-request', 'StudentController@approve_request')->name('admin.students.approve_requests');

    Route::get('students/{id}/decline-request', 'StudentController@decline_request')->name('admin.students.decline_requests');

    Route::get('students/print', 'StudentController@print');
    Route::get('students/export-excel', 'StudentController@export_csv');
    Route::get('students/{id}/accept-update-request', 'StudentController@accept_update_request');
    Route::resource('students', 'StudentController', ["as" => 'admin']);

    Route::resource('shifts', 'ShiftController', ["as" => 'admin']);
    Route::resource('sessions', 'SessionController', ["as" => 'admin']);
    Route::resource('teachers', 'TeacherController', ["as" => 'admin']);
    Route::resource('teacherDetails', 'TeacherDetailController', ["as" => 'admin']);
    Route::resource('studentClasses', 'StudentClassController', ["as" => 'admin']);
    Route::resource('sections', 'SectionController', ["as" => 'admin']);
    Route::resource('studentDetails', 'StudentDetailController', ["as" => 'admin']);
    Route::resource('liveClasses', 'LiveClassController', ["as" => 'admin']);
    Route::resource('subjects', 'SubjectController', ["as" => 'admin']);
    Route::resource('roles', 'RoleController', ["as" => 'admin']);
    Route::resource('permissions', 'PermissionController', ["as" => 'admin']);
    Route::resource('countries', 'CountryController', ["as" => 'admin']);

});





Route::group(['prefix' => 'admin'], function () {
    Route::resource('liveClasses', 'LiveClassController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('liveClasses', 'LiveClassController', ["as" => 'admin']);
});






Route::group(['prefix' => 'admin'], function () {
    Route::resource('transactions', 'TransactionController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('packages', 'PackageController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('batches', 'BatchController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('sliders', 'SliderController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('blogs', 'BlogController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('packageCategories', 'PackageCategoryController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('homeWorks', 'HomeWorkController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('notices', 'NoticeController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('homeWorks', 'HomeWorkController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('classNotes', 'ClassNoteController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('duas', 'DuaController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('channels', 'ChannelController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('questions', 'QuestionController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('manners', 'MannerController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('quranAdults', 'QuranAdultController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('quranKids', 'QuranKidController', ["as" => 'admin']);
});




Route::group(['prefix' => 'admin'], function () {
    Route::resource('accessInformations', 'AccessInformationController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('accessInformations', 'AccessInformationController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('accessInformations', 'AccessInformationController', ["as" => 'admin']);
});




Route::group(['prefix' => 'admin'], function () {
    Route::resource('accessInformations', 'AccessInformationController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('partners', 'PartnerController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('testimonials', 'TestimonialController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('faqs', 'FaqController', ["as" => 'admin']);
});




Route::group(['prefix' => 'admin'], function () {
    Route::resource('galleryCategories', 'GalleryCategoryController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('galleries', 'GalleryController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('events', 'EventController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('jobs', 'JobController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('eventSubscribers', 'EventSubscriberController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('memberCategories', 'MemberCategoryController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('members', 'MemberController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('newsletters', 'NewsletterController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('stories', 'StoryController', ["as" => 'admin']);
});










Route::group(['prefix' => 'admin'], function () {
    Route::resource('jobSubscribers', 'JobSubscriberController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('blogCategories', 'BlogCategoryController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('contacts', 'ContactController', ["as" => 'admin']);
});


Route::group(['prefix' => 'admin'], function () {
    Route::resource('studentAwards', 'StudentAwardController', ["as" => 'admin']);
    Route::get('student_awards/{student_id}', 'StudentAwardController@student_awards');

});




Route::group(['prefix' => 'admin'], function () {
    Route::resource('publications', 'PublicationController', ["as" => 'admin']);
});
