@section('title') Home @stop
@extends('front.layout.master')
@section('content')
	<!-- Banner Area Start-->
    <section class="banner-area">
        <div class="banner-slider owl-carousel owl-theme">

            @foreach(\App\Models\Slider::active()->get() as $slider)
                <div class="item" style="background: url({{ asset('uploads/sliders/' . $slider->image) }});">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-9 align-self-center">
                                <div class="banner-inner">
                                    <h1>{{ $slider->title }}</h1>
                                    <h2>{{ $slider->title_sub }}</h2>
                                    <a class="btn btn-blue" href="{{ $slider->read_more_link }}">{{ $slider->read_more_title }}</a>
                                    {{-- <a class="btn btn-base" href="">Talk to me</a> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
            {{-- <div class="item" style="background: url(/front/assets/img/banner/bg.png);">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-9 align-self-center">
                            <div class="banner-inner">
                                <h1>Find your courses, Apply Now.</h1>
                                <a class="btn btn-blue" href="product.html">Click here</a>
                                <a class="btn btn-base" href="product.html">Talk to me</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div> --}}
        </div>
    </section>
    <!-- Banner Area End -->

    <!-- Service-Area Start-->
    <section class="service-area text-center pd-top-115 pd-bottom-70">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-9">
                    <div class="section-title text-center">
                        <h2 class="title">{!! setting('our_service_title') !!}</h2>
                        <p>{!! setting('our_service_description') !!}</p>
                    </div>                    
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-4 col-md-6 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.1s">
                    <div class="single-service-wrap">
                        <div class="thumb">
                            <img src="/front/assets/img/service/1.png" alt="img">
                        </div>
                        <div class="service-wrap-details">
                            <span>1</span>
                            <h6><a href="#">{!! setting('our_service_1_name') !!}</a></h6>
                            <p>{!! setting('our_service_1_des') !!}</p>
                        </div>
                    </div>   
                </div>
                <div class="col-lg-4 col-md-6 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.3s">
                    <div class="single-service-wrap">
                        <div class="thumb">
                            <img src="/front/assets/img/service/2.png" alt="img">
                        </div>
                        <div class="service-wrap-details">
                            <span>2</span>
                            <h6><a href="#">{!! setting('our_service_2_name') !!}</a></h6>
                            <p>{!! setting('our_service_2_des') !!}</p>
                        </div>
                    </div> 
                </div>
                <div class="col-lg-4 col-md-6 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.6s">
                    <div class="single-service-wrap">
                        <div class="thumb">
                            <img src="/front/assets/img/service/3.png" alt="img">
                        </div>
                        <div class="service-wrap-details">
                            <span>3</span>
                            <h6><a href="#">{!! setting('our_service_3_name') !!}</a></h6>
                            <p>{!! setting('our_service_3_des') !!}</p>
                        </div>
                    </div>   
                </div>
            </div>
        </div>
    </section>
    <!-- Service-Area End-->

    <!-- courses-Area Start-->
    <section class="courses-area pd-top-66 pd-bottom-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section-title text-center">
                        <h2 class="title text-white">Our Latest Courses</h2>
                        <p class="text-white">  simply dummy text of the printing and typesetting industry. Lorem Ipsum simply dummy text of the printing and typesetting</p>
                    </div>                    
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="course-slider owl-carousel owl-theme">
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/1.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">Business</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">Business Studies</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/2.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">Computer</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">Computer Engineering</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/3.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">English</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">English For Tommorow</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/1.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">Business</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">Business Studies</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/2.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">Computer</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">Computer Engineering</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/3.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">English</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">English For Tommorow</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/1.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">Business</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">Business Studies</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/2.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">Computer</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">Computer Engineering</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="single-course-wrap">
                                <div class="thumb">
                                    <img src="/front/assets/img/course/3.png" alt="img">
                                </div>
                                <div class="course-wrap-details">
                                    <a href="#" class="tag">English</a>
                                    <span class="author"><img src="/front/assets/img/course/author.png"></span>
                                    <h5><a href="#">English For Tommorow</a></h5>
                                    <p> simply dummy text of the printing  simply dummy text </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>      
    </section>
    <!-- courses-Area End-->

    <!-- team-Area Start-->
    {{-- <div class="team-area bg-grey pd-top-84 pd-bottom-70 text-center">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-9">
                    <div class="section-title text-center">
                        <h2 class="title">Our Specialists</h2>
                        <p> simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the dummy text of the printing and typesetting industry. Lorem Ipsum has been the </p>
                    </div>                    
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-3 col-md-6 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.1s">
                    <div class="single-team-wrap">
                        <div class="thumb">
                            <img src="/front/assets/img/team/1.png" alt="img">
                        </div>
                        <div class="team-wrap-details">
                            <h4><a href="#">Stan Lee</a></h4>
                            <p>Teacher</p>
                        </div>
                    </div>   
                </div>
                <div class="col-lg-3 col-md-6 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.3s">
                    <div class="single-team-wrap">
                        <div class="thumb">
                            <img src="/front/assets/img/team/2.png" alt="img">
                        </div>
                        <div class="team-wrap-details border-blue">
                            <h4><a href="#">Stan Lee</a></h4>
                            <p>Teacher</p>
                        </div>
                    </div>   
                </div>
                <div class="col-lg-3 col-md-6 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.6s">
                    <div class="single-team-wrap">
                        <div class="thumb">
                            <img src="/front/assets/img/team/3.png" alt="img">
                        </div>
                        <div class="team-wrap-details">
                            <h4><a href="#">Stan Lee</a></h4>
                            <p>Teacher</p>
                        </div>
                    </div>   
                </div>
                <div class="col-lg-3 col-md-6 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.9s">
                    <div class="single-team-wrap">
                        <div class="thumb">
                            <img src="/front/assets/img/team/4.png" alt="img">
                        </div>
                        <div class="team-wrap-details border-blue-2">
                            <h4><a href="#">Stan Lee</a></h4>
                            <p>Teacher</p>
                        </div>
                    </div>   
                </div>
            </div>
        </div>
    </div> --}}
    <!-- team-Area End-->

    <!-- partner-Area Start-->
    <div class="partner-area pd-top-84 pd-bottom-70 text-center">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-9">
                    <div class="section-title text-center">
                        <h2 class="title">Our Partner</h2>
                    </div>                    
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="partner-slider owl-carousel owl-theme">

                        @foreach(\App\Models\Partner::active()->get() as $partner)
                            <div class="single-partner-wrap">
                                <div class="thumb">
                                    <img src="{{ asset('uploads/partners/' . $partner->image) }}" alt="img">
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- partner-Area End-->

    

    <!-- event-Area Start-->
    {{-- <section class="event-area pd-top-84">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-9">
                    <div class="section-title text-center">
                        <h2 class="title">Up Coming Events</h2>
                        <p>  simply dummy text of the printing and typesetting industry</p>
                    </div>                    
                </div>
            </div>
            <div class="row justify-content-center no-gutters">
                <div class="col-lg-4">
                    <div class="event-details-wrap text-center">
                        <div class="event-details-inner text-left">
                            <ul>
                                <li>Computer Management</li>
                                <li>English For Today</li>
                                <li>IELTS</li>
                            </ul>
                            <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy  </p>
                            <div class="meta">
                                <span class="user">
                                    <img src="/front/assets/img/icon/user.png">0
                                </span>
                                <span class="time">
                                    <img src="/front/assets/img/icon/time.png">20 h 30 m
                                </span>
                                <span class="lesson">
                                    <img src="/front/assets/img/icon/book.png">Lessons
                                </span>
                            </div>
                        </div>
                        <a class="btn btn-base" href="#">See More</a> 
                    </div>  
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="event-portfolio">
                        <div class="thumb">
                            <img src="/front/assets/img/event/1.png" alt="img">
                        </div>
                        <div class="date text-center">
                            <h5>08</h5>
                            <h6>Sep</h6>
                        </div>
                    </div> 
                    <div class="event-portfolio">
                        <div class="thumb">
                            <img src="/front/assets/img/event/2.png" alt="img">
                        </div>
                        <div class="date text-center">
                            <h5>09</h5>
                            <h6>Sep</h6>
                        </div>
                    </div> 
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="event-portfolio">
                        <div class="thumb">
                            <img src="/front/assets/img/event/3.png" alt="img">
                        </div>
                        <div class="date text-center">
                            <h5>05</h5>
                            <h6>Sep</h6>
                        </div>
                    </div> 
                    <div class="event-portfolio">
                        <div class="thumb">
                            <img src="/front/assets/img/event/4.png" alt="img">
                        </div>
                        <div class="date text-center">
                            <h5>09</h5>
                            <h6>Sep</h6>
                        </div>
                    </div> 
                </div>
            </div>
        </div>
    </section> --}}
    <!-- event-Area End-->




    <!-- video area start here -->
    <section class="video-area pd-top-84 pd-bottom-100" style="background: url( {{ asset('uploads/settings/') . '/' . setting('video_section_bg') }} );">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section-title text-center">
                        <h2 class="title text-white">{{ setting('video_section_title') }}</h2>
                        <p class="text-white">{{ setting('video_section_description') }}</p>
                        <a class="video-play-btn btn-ripple-animate" href="{{ setting('video_section_link_url') }}" data-effect="mfp-zoom-in"><i class="fa fa-play"></i></a>
                    </div>                    
                </div>
            </div>
        </div>
    </section>
    <!-- video area end here -->



    <!--fun-fact-area start-->
    <div class="fun-fact-area pd-top-120 pd-bottom-103">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-3 col-sm-6 text-center">
                    <div class="single-fact">
                        <div class="thumb">
                            <img src="{{ asset('uploads/settings/') . '/' . setting('counter_1_icon') }}">
                        </div>
                        <h2 class="counter">{{ setting('counter_1_number') }}</h2>
                        <h4>{{ setting('counter_1_title') }}</h4>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 text-center">
                    <div class="single-fact">
                        <div class="thumb">
                            <img src="{{ asset('uploads/settings/') . '/' . setting('counter_2_icon') }}">
                        </div>
                        <h2 class="counter">{{ setting('counter_2_number') }}</h2>
                        <h4>{{ setting('counter_2_title') }}</h4>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 text-center">
                    <div class="single-fact">
                        <div class="thumb">
                            <img src="{{ asset('uploads/settings/') . '/' . setting('counter_3_icon') }}">
                        </div>
                        <h2 class="counter">{{ setting('counter_3_number') }}</h2>
                        <h4>{{ setting('counter_3_title') }}</h4>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 text-center">
                    <div class="single-fact">
                        <div class="thumb">
                            <img src="{{ asset('uploads/settings/') . '/' . setting('counter_4_icon') }}">
                        </div>
                        <h2 class="counter">{{ setting('counter_4_number') }}</h2>
                        <h4>{{ setting('counter_4_title') }}</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--fun-fact-area end-->

    <!-- testimonial area start here -->
    <section class="testimonial-area pd-top-84 pd-bottom-100" style="background: url({{ asset('uploads/settings/') . '/' . setting('testimonial_section_bg') }});">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section-title text-center">
                        <h2 class="title text-white">{{ setting('testimonial_section_title') }}</h2>
                        <p class="text-white">{{ setting('testimonial_section_description') }}</p>
                    </div>                    
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="testimonial-slider owl-carousel">

                        @foreach(\App\Models\Testimonial::active()->get() as $testimonial)

                            <div class="item">
                                <div class="single-testimonial">
                                    <i class="quote-icon fa fa-quote-right"></i>
                                    <div class="thumb">
                                        <img src="{{ asset('uploads/testimonials/' . $testimonial->image) }}" alt="testimonail-author">
                                    </div>
                                    <h4><a class="user-name" href="#">{{ $testimonial->name }}</a></h4>
                                    <p>{{ $testimonial->description }}</p>
                                    {{-- <div class="ratting">
                                        <i class="la la-star"></i>
                                        <i class="la la-star"></i>
                                        <i class="la la-star"></i>
                                        <i class="la la-star"></i>
                                        <i class="la la-star-o"></i>
                                    </div>     --}}                            
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- testimonial area end here -->

    <!--register-area start-->
    <div class="register-area half-bg-yellow pd-top-60 pd-bottom-60">
        <div class="container">
            <div class="row justify-content-center no-gutters">
                <div class="col-lg-5 col-md-6 text-center">
                    <div class="single-register-form">
                        <h6>Register for get 60+ Courses Free Access</h6>
                        @include('components.errors')
                        <form action="{{ action('WebController@student_register_store')}}" method="POST">
                            <div class="single-input-wrap">
                                <input type="text" name="name" placeholder="Name" required="required">
                            </div>
                            <div class="single-input-wrap">
                                <input type="text" name="email" placeholder="E-mail" required="required">
                            </div>
                            <div class="single-input-wrap">
                                <input type="text" name="phone" placeholder="Phone Number" required="required">
                            </div>
                            {{-- <div class="single-input-wrap">
                                <input type="text" name="subject" placeholder="Subject">
                            </div> --}}
                            <div class="single-input-wrap" required="required">
                                <input type="password" name="password" placeholder="Password">
                            </div>
                            <input type="submit" class="btn btn-blue w-100" value="GET IT NOW">
                        </form>
                    </div>
                </div>
                <div class="col-lg-6 offset-lg-1 col-md-6">
                    <div class="register-wrap">
                        <div class="register-wrap-details">
                            <h2>Register Now</h2>
                            <h4>Get 60+ Courses Free Access</h4>
                            <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy</p>
                        </div>
                        <div id="countdown" class="countdown-area">
                            <ul>
                              <li><span id="days"></span>Days</li>
                              <li><span id="hours"></span>Hours</li>
                              <li><span id="minutes"></span>Minutes</li>
                              <li><span id="seconds"></span>Seconds</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--register-area end-->

    <!-- schedule area start here -->
    {{-- <section class="schedule-area pd-top-84 pd-bottom-100" style="background: url(/front/assets/img/schedule/bg.png);">
        <div class="container">
            <div class="row justify-content-center no-gutters">
                <div class="col-lg-12">
                    <div class="section-title">
                        <h2 class="title text-white">Popular Live Lessons</h2>
                    </div>                    
                </div>
                <div class="col-lg-4">
                    <div class="calender">
                        <img class="w-100" src="/front/assets/img/schedule/1.png">
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="table-responsive">
                        <h5>Education Schedule of this week :</h5>
                        <table class="schedule-table table">
                            <tbody>
                                <tr>
                                    <th scope="row">Sun<span>9 Nov</span></th>
                                    <td class="time">2 :00 PM GMT <span>3 :00 PM GMT</span></td>
                                    <td>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's </td>
                                </tr>
                                <tr>
                                    <th scope="row">Sun<span>9 Nov</span></th>
                                    <td class="time">2 :00 PM GMT <span>3 :00 PM GMT</span></td>
                                    <td>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's </td>
                                </tr>
                                <tr>
                                    <th scope="row">Sun<span>9 Nov</span></th>
                                    <td class="time">2 :00 PM GMT <span>3 :00 PM GMT</span></td>
                                    <td>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-12">
                    <a class="btn btn-white" href="#">JOIN</a>
                </div>
            </div>
        </div>
    </section> --}}
    <!-- schedule area end here -->

    <!-- faq-Area Start-->
    <div class="faq-area bg-grey pd-top-70 pd-bottom-70">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="faq-area-inner">
                        <div class="section-title text-center">
                            <h2 class="title">Frequently asked questions</h2>
                        </div> 
                        <div class="accordion">
                            @php $i = 1; @endphp
                            @foreach(\App\Models\Faq::active()->get() as $faq)
                                <div class="card">
                                    <div class="card-header">
                                        <button class="collapsed" type="button" data-toggle="collapse" data-target="#collapse{{ $faq->id }}">
                                            {{ $i }}. {{ $faq->title }}
                                            </button>
                                    </div>
                                    <div id="collapse{{ $faq->id }}" class="collapse">
                                        <div class="card-body">
                                            <p>{{ $faq->answer }}</p>
                                        </div>
                                    </div>
                                </div>
                                @php $i++; @endphp
                            @endforeach
                        </div>
                    </div>                   
                </div>
            </div>
        </div>
    </div>
    <!-- faq-Area End-->

    <!--contact-area start-->
    <div class="contact-area pd-top-70 pd-bottom-65">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-4 col-sm-6 text-center">
                    <div class="single-contact-wrap">
                        <i class="fa fa-map-marker-alt"></i>
                        <p>{!! setting('app_address') !!}</p>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6 text-center">
                    <div class="single-contact-wrap">
                        <i class="fa fa-phone-alt"></i>
                        <p>{!! setting('app_contact') !!}</p>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6 text-center">
                    <div class="single-contact-wrap">
                        <i class="fa fa-envelope"></i>
                        <p>{!! setting('app_email') !!}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--contact-area end-->
@endsection