<div class="table-responsive">
    <table class="table" id="notices-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Title</th>
        <th>Image</th>
        <th>Status</th>
                <th colspan="3">Action</th>
            </tr>
        </thead>
        <tbody>
        @foreach($notices as $notice)
            <tr>
                <td>{{$notice->id}}</td>
                <td>{{ $notice->title }}</td>
                <td>{!! $notice->imageToShow() !!}</td>
                <td>{!! $notice->status_buttons() !!}</td>
                <td>
                    {!! Form::open(['route' => ['admin.notices.destroy', $notice->id], 'method' => 'delete']) !!}
                    <div class='btn-group'>
                        <a href="{{ route('admin.notices.show', [$notice->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-eye-open"></i></a>
                        <a href="{{ route('admin.notices.edit', [$notice->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-edit"></i></a>
                        {!! Form::button('<i class="glyphicon glyphicon-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'onclick' => "return confirm('Are you sure?')"]) !!}
                    </div>
                    {!! Form::close() !!}
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>
