<div class="table-responsive">
    <table class="table table2excel table2excel_with_colors" id="jobs-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Title</th>
                <th>Salary</th>
                <th>Salary Negotialble</th>
                <th>Position</th>
                <th>Dead Line</th>
                <th>CV</th>
                <th>Cmp Image</th>
                <th>Completed</th>
                <th>Status</th>
                <th colspan="3">Action</th>
            </tr>
        </thead>
        <tbody>
        @foreach($jobs as $job)
            <tr>
                <td>{{ $job->id }}</td>
                <td>{{ $job->title }}</td>
                <td>${{ $job->salary }}</td>
                <td>{!! $job->status_buttons('salary_negotialble') !!}</td>
                <td>{{ $job->position }}</td>
                <td>{{ $job->dead_line }}</td>
                <td>{!! $job->imageToShow('cv') !!}</td>
                <td>{!! $job->imageToShow('cmp_image') !!}</td>
                <td>{!! $job->status_buttons('completed') !!}</td>
                <td>{!! $job->status_buttons('status') !!}</td>
                <td>
                    {!! Form::open(['route' => ['admin.jobs.destroy', $job->id], 'method' => 'delete']) !!}
                    <div class='btn-group'>
                        <a href="{{ route('admin.jobs.show', [$job->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-eye-open"></i></a>
                        <a href="{{ route('admin.jobs.edit', [$job->id]) }}" class='btn btn-default btn-xs'><i class="glyphicon glyphicon-edit"></i></a>
                        {!! Form::button('<i class="glyphicon glyphicon-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-xs', 'onclick' => "return confirm('Are you sure?')"]) !!}
                    </div>
                    {!! Form::close() !!}
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <button class="exportToExcel">Export to Excel</button>
</div>

