<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('members', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('category_id')->unsigned();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('profession')->nullable();
            $table->string('company_name')->nullable();
            $table->text('image')->nullable();
            $table->text('description')->nullable();
            $table->text('body')->nullable();

            $table->string('social_facebook')->nullable();
            $table->string('social_twitter')->nullable();
            $table->string('social_linkedin')->nullable();
            $table->string('social_wechat')->nullable();

            $table->integer('status')->nullable();
            $table->timestamps();
            $table->foreign('category_id')->references('id')->on('member_categories');
        });
        
        $file = realpath(__DIR__.'/../catalogs/members.sql');
        DB::unprepared( file_get_contents($file) );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('members');
    }
}
