<?php 
// https://www.qcode.in/save-laravel-app-settings-in-database/
// setting($key)
return [
    'app_logos' => [
        'title' => 'Logo',
        'desc' => 'All the Logo settings',
        'icon' => 'glyphicon glyphicon-sunglasses',

        'elements' => [
            [
                'type' => 'file', // input fields type
                'data' => 'file', // data type, string, int, boolean
                'name' => 'app_header_logo', // unique name for field
                'label' => 'Main Logo', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'main_logo.png' // default value if you want
            ],
            [
                'type' => 'file', // input fields type
                'data' => 'file', // data type, string, int, boolean
                'name' => 'app_footer_logo', // unique name for field
                'label' => 'Footer Logo', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'footer_logo.png' // default value if you want
            ],
            [
                'type' => 'file', // input fields type
                'data' => 'file', // data type, string, int, boolean
                'name' => 'app_sticky_logo', // unique name for field
                'label' => 'Sticky Logo', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'sticky_logo.png' // default value if you want
            ],
            [
                'type' => 'file', // input fields type
                'data' => 'file', // data type, string, int, boolean
                'name' => 'app_favicon_logo', // unique name for field
                'label' => 'Favicon', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'app_favicon.ico' // default value if you want
            ],
        ]
    ],
    'app' => [
        'title' => 'General',
        'desc' => 'All the general settings for application.',
        'icon' => 'glyphicon glyphicon-sunglasses',

        'elements' => [
            [
                'type' => 'text', // input fields type
                'data' => 'string', // data type, string, int, boolean
                'name' => 'app_name', // unique name for field
                'label' => 'App Name', // you know what label it is
                'rules' => 'min:2|max:50', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'ABCA | Association of Bangladesh' // default value if you want
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'app_email',
                'label' => 'App Email',
                'rules' => 'email',
                'class' => '',
                'value' => 'info@abc-alumni.org'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'app_contact',
                'label' => 'App Contact',
                'rules' => '',
                'class' => '',
                'value' => '(+88) 01711 234056 (Bangladesh)'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'app_contact_2',
                'label' => 'App Contact 2',
                'rules' => '',
                'class' => '',
                'value' => '(+86) 18800312148 (China)'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'app_address',
                'label' => 'App Address',
                'rules' => '',
                'class' => '',
                'value' => 'Address'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'app_copyright',
                'label' => 'Copyright',
                'rules' => '',
                'class' => '',
                'value' => '©2021 Association of Bangladesh China Alumni'
            ]
        ]
    ],
    'seo' => [

        'title' => 'SEO',
        'desc' => 'SEO settings for app',
        'icon' => 'glyphicon glyphicon-globe',

        'elements' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'title',
                'label' => 'Site Title',
                'rules' => '',
                'class' => '',
                'value' => 'ABCA'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'meta_keywords',
                'label' => 'Meta keywords',
                'rules' => '',
                'class' => '',
                'value' => 'ABCA'
            ],
            [
                'type' => 'textarea',
                'data' => 'string',
                'name' => 'meta_description',
                'label' => 'Meta description',
                'rules' => '',
                'class' => '',
                'value' => ''
            ],
        ]
    ],
    'home-section' => [

        'title' => 'Home Section',
        'desc' => 'Home Section In HomePage',
        'icon' => 'glyphicon glyphicon-envelope',

        'elements' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'notice_section_title',
                'label' => 'Notice Section Title',
                'rules' => '',
                'class' => '',
                'value' => 'Conferences'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'publication_section_title',
                'label' => 'Publication Section Title',
                'rules' => '',
                'class' => '',
                'value' => 'Publication'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'news_section_title',
                'label' => 'News Section Title',
                'rules' => '',
                'class' => '',
                'value' => 'News'
            ],
            [
                'type' => 'file', // input fields type
                'data' => 'file', // data type, string, int, boolean
                'name' => 'video_section_bg', // unique name for field
                'label' => 'video Section Bg', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'video_section_bg.jpg' // default value if you want
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'video_section_youtube_url',
                'label' => 'Video Section Url',
                'rules' => '',
                'class' => '',
                'value' => 'https://www.youtube.com/watch?v=x40a0OJuEi4'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'testimonial_title',
                'label' => 'Testimonial Title',
                'rules' => '',
                'class' => '',
                'value' => 'WHAT PEOPLES ARE SAYING'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'news_letter_title',
                'label' => 'News Letter Title',
                'rules' => '',
                'class' => '',
                'value' => 'Keep Up and Join Our Newsletter
                '
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'news_letter_description',
                'label' => 'News Letter Description',
                'rules' => '',
                'class' => '',
                'value' => 'Duis autem vel eum iriure dolor in hendrerit in vulputate.'
            ],
            [
                'type' => 'file', // input fields type
                'data' => 'file', // data type, string, int, boolean
                'name' => 'news_letter_bg', // unique name for field
                'label' => 'News Letter Bg', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'news_letter_bg.jpg' // default value if you want
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'contact_sec_title',
                'label' => 'Contact Section Title',
                'rules' => '',
                'class' => '',
                'value' => 'Get in Touch'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'about_sec_title',
                'label' => 'About Section Title',
                'rules' => '',
                'class' => '',
                'value' => 'About Us'
            ],
            [
                'type' => 'textarea',
                'data' => 'text',
                'name' => 'about_sec_body',
                'label' => 'About Section Body',
                'rules' => '',
                'class' => '',
                'value' => 'Formats a HTML string/file with your desired indentation level. The formatting rules are not configurable but are already optimized for the best possible output. Note that the formatter will keep spaces and tabs between content tags such as div and span as it\'s considered to be valid content.'
            ],
        ]
    ],
    'about-us-page' => [

        'title' => 'About Us Page Section',
        'desc' => 'About Us Page In Single Page',
        'icon' => 'glyphicon glyphicon-envelope',

        'elements' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'about_page_head_title',
                'label' => 'About Page Head Title',
                'rules' => '',
                'class' => '',
                'value' => 'ABOUT US'
            ],
            [
                'type' => 'file',
                'data' => 'file',
                'name' => 'about_us_bg',
                'label' => 'About Us Bg',
                'rules' => '',
                'class' => '',
                'value' => 'about_us_bg.jpg'
            ],
            [
                'type' => 'textarea',
                'data' => 'text',
                'name' => 'about_page_description',
                'label' => 'About Page Description',
                'rules' => '',
                'class' => '',
                'value' => '
                    Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Typi non habent claritatem insitam; est usus legentis in iis qui facit eorum claritatem. Investigationes demonstraverunt lectores legere me lius quod ii legunt saepius.<br />

                    Investigationes demonstraverunt lectores. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Typi non habent claritatem insitam; est usus legentis in iis qui facit eorum claritatem. Investigationes demonstraverunt lectores legere me lius quod ii legunt saepius.
                '
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'about_page_title',
                'label' => 'About Page Title',
                'rules' => '',
                'class' => '',
                'value' => 'Who We Are'
            ],
            [
                'type' => 'file',
                'data' => 'file',
                'name' => 'about_left_image', // unique name for field
                'label' => 'About Left Image', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'about_left_image.jpg' // default value if you want
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'about_page_tab_1_title',
                'label' => 'About Page Tab 1 Title',
                'rules' => '',
                'class' => '',
                'value' => 'Tab1'
            ],
            [
                'type' => 'textarea',
                'data' => 'text',
                'name' => 'about_page_tab_1_description',
                'label' => 'About Page Tab 1 Description',
                'rules' => '',
                'class' => '',
                'value' => '
                    <div class="tab-content-wrapper">
                        <p class="text-light">
                            Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse
                            molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros
                            et accumsan.
                        </p>
                        <ul class="list-item text-light">
                            <li>Feugiat nulla facilisis at vero eros et accumsan et iusto.</li>
                            <li>Luptatum zzril delenit augue duis dolore.</li>
                            <li>Vulputate velit esse molestie consequat.</li>
                            <li>Delenit augue duis dolore vulputate velit esse molestie consequat</li>
                        </ul>
                    </div>
                '
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'about_page_tab_2_title',
                'label' => 'About Page Tab 2 Title',
                'rules' => '',
                'class' => '',
                'value' => 'Tab2'
            ],
            [
                'type' => 'textarea',
                'data' => 'text',
                'name' => 'about_page_tab_2_description',
                'label' => 'About Page Tab 2 Description',
                'rules' => '',
                'class' => '',
                'value' => '
                    <div class="tab-content-wrapper">
                        <p class="text-light">
                            Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse
                            molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros
                            et accumsan.
                        </p>
                        <ul class="list-item text-light">
                            <li>Feugiat nulla facilisis at vero eros et accumsan et iusto.</li>
                            <li>Luptatum zzril delenit augue duis dolore.</li>
                            <li>Vulputate velit esse molestie consequat.</li>
                            <li>Delenit augue duis dolore vulputate velit esse molestie consequat</li>
                        </ul>
                    </div>
                '
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'about_page_tab_3_title',
                'label' => 'About Page Tab 3 Title',
                'rules' => '',
                'class' => '',
                'value' => 'Tab3'
            ],
            [
                'type' => 'textarea',
                'data' => 'text',
                'name' => 'about_page_tab_3_description',
                'label' => 'About Page Tab 3 Description',
                'rules' => '',
                'class' => '',
                'value' => '
                    <div class="tab-content-wrapper">
                        <p class="text-light">
                            Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse
                            molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros
                            et accumsan.
                        </p>
                        <ul class="list-item text-light">
                            <li>Feugiat nulla facilisis at vero eros et accumsan et iusto.</li>
                            <li>Luptatum zzril delenit augue duis dolore.</li>
                            <li>Vulputate velit esse molestie consequat.</li>
                            <li>Delenit augue duis dolore vulputate velit esse molestie consequat</li>
                        </ul>
                    </div>
                '
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'about_page_tab_4_title',
                'label' => 'About Page Tab 4 Title',
                'rules' => '',
                'class' => '',
                'value' => 'Tab4'
            ],
            [
                'type' => 'textarea',
                'data' => 'text',
                'name' => 'about_page_tab_4_description',
                'label' => 'About Page Tab 4 Description',
                'rules' => '',
                'class' => '',
                'value' => '
                    <div class="tab-content-wrapper">
                        <p class="text-light">
                            Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse
                            molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros
                            et accumsan.
                        </p>
                        <ul class="list-item text-light">
                            <li>Feugiat nulla facilisis at vero eros et accumsan et iusto.</li>
                            <li>Luptatum zzril delenit augue duis dolore.</li>
                            <li>Vulputate velit esse molestie consequat.</li>
                            <li>Delenit augue duis dolore vulputate velit esse molestie consequat</li>
                        </ul>
                    </div>
                '
            ],
        ]
    ],
    // 'our-services' => [

    //     'title' => 'Our Services',
    //     'desc' => 'Our Service Area In HomePage',
    //     'icon' => 'glyphicon glyphicon-envelope',

    //     'elements' => [
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'our_service_title',
    //             'label' => 'Title',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Welcome to our home'
    //         ],
    //         [
    //             'type' => 'textarea',
    //             'data' => 'string',
    //             'name' => 'our_service_description',
    //             'label' => 'Description',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Phasellus vitae velit sit amet diam semper commodo quis quis libero. Morbi consequat arcu augue, molestie faucibus metus ullamcorper vel.'
    //         ],
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'our_service_1_name',
    //             'label' => 'Service 1 Name',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Expand knowledge'
    //         ],
    //         [
    //             'type' => 'textarea',
    //             'data' => 'string',
    //             'name' => 'our_service_1_des',
    //             'label' => 'Service 1 Description',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry'
    //         ],
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'our_service_2_name',
    //             'label' => 'Service 2 Name',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Develop Your skill'
    //         ],
    //         [
    //             'type' => 'textarea',
    //             'data' => 'string',
    //             'name' => 'our_service_2_des',
    //             'label' => 'Service 2 Description',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry'
    //         ],
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'our_service_3_name',
    //             'label' => 'Service 3 Name',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Learn Yourself'
    //         ],
    //         [
    //             'type' => 'textarea',
    //             'data' => 'string',
    //             'name' => 'our_service_3_des',
    //             'label' => 'Service 3 Description',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry'
    //         ],
    //     ]
    // ],


    // 'video-section' => [

    //     'title' => 'Video Section',
    //     'desc' => 'Video Section In HomePage',
    //     'icon' => 'glyphicon glyphicon-envelope',

    //     'elements' => [
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'video_section_title',
    //             'label' => 'Title',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Watch Our Latest Video'
    //         ],
    //         [
    //             'type' => 'textarea',
    //             'data' => 'string',
    //             'name' => 'video_section_description',
    //             'label' => 'Description',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Lorem Ipsum is simply dummy text of the printing and typesetting Lorem Ipsum is simply dummy text of the printing.'
    //         ],
    //         [
    //             'type' => 'file', // input fields type
    //             'data' => 'file', // data type, string, int, boolean
    //             'name' => 'video_section_bg', // unique name for field
    //             'label' => 'Video Section Bg', // you know what label it is
    //             'rules' => '', // validation rule of laravel
    //             'class' => '', // any class for input
    //             'value' => 'video_section_bg.png' // default value if you want
    //         ],
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'video_section_link_url',
    //             'label' => 'Video Url',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'https://www.youtube.com/embed/Wimkqo8gDZ0'
    //         ],
    //     ]
    // ],

    // 'counter-section' => [

    //     'title' => 'Counter Section',
    //     'desc' => 'Counter Section In HomePage',
    //     'icon' => 'glyphicon glyphicon-envelope',

    //     'elements' => [
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'counter_1_title',
    //             'label' => 'Counter 1 Title',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Satisfied Students'
    //         ],
    //         [
    //             'type' => 'file', // input fields type
    //             'data' => 'file', // data type, string, int, boolean
    //             'name' => 'counter_1_icon', // unique name for field
    //             'label' => 'Counter 1 Icon', // you know what label it is
    //             'rules' => '', // validation rule of laravel
    //             'class' => '', // any class for input
    //             'value' => 'counter_1_icon.png' // default value if you want
    //         ],
    //         [
    //             'type' => 'number',
    //             'data' => 'string',
    //             'name' => 'counter_1_number',
    //             'label' => 'Counter 1 Number',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => '12558'
    //         ],
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'counter_2_title',
    //             'label' => 'Counter 2 Title',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Courses Completed'
    //         ],
    //         [
    //             'type' => 'file', // input fields type
    //             'data' => 'file', // data type, string, int, boolean
    //             'name' => 'counter_2_icon', // unique name for field
    //             'label' => 'Counter 2 Icon', // you know what label it is
    //             'rules' => '', // validation rule of laravel
    //             'class' => '', // any class for input
    //             'value' => 'counter_2_icon.png' // default value if you want
    //         ],
    //         [
    //             'type' => 'number',
    //             'data' => 'string',
    //             'name' => 'counter_2_number',
    //             'label' => 'Counter 2 Number',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => '8975'
    //         ],
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'counter_3_title',
    //             'label' => 'Counter 3 Title',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Satisfied Students'
    //         ],
    //         [
    //             'type' => 'file', // input fields type
    //             'data' => 'file', // data type, string, int, boolean
    //             'name' => 'counter_3_icon', // unique name for field
    //             'label' => 'Counter 3 Icon', // you know what label it is
    //             'rules' => '', // validation rule of laravel
    //             'class' => '', // any class for input
    //             'value' => 'counter_3_icon.png' // default value if you want
    //         ],
    //         [
    //             'type' => 'number',
    //             'data' => 'string',
    //             'name' => 'counter_3_number',
    //             'label' => 'Counter 3 Number',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => '6849'
    //         ],
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'counter_4_title',
    //             'label' => 'Counter 4 Title',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Expert Advisors'
    //         ],
    //         [
    //             'type' => 'file', // input fields type
    //             'data' => 'file', // data type, string, int, boolean
    //             'name' => 'counter_4_icon', // unique name for field
    //             'label' => 'Counter 4 Icon', // you know what label it is
    //             'rules' => '', // validation rule of laravel
    //             'class' => '', // any class for input
    //             'value' => 'counter_4_icon.png' // default value if you want
    //         ],
    //         [
    //             'type' => 'number',
    //             'data' => 'string',
    //             'name' => 'counter_4_number',
    //             'label' => 'Counter 4 Number',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => '380'
    //         ],
    //     ]
    // ],
    // 'testimonial-section' => [

    //     'title' => 'Testimonial Section',
    //     'desc' => 'Testimonial Section In HomePage',
    //     'icon' => 'glyphicon glyphicon-envelope',

    //     'elements' => [
    //         [
    //             'type' => 'text',
    //             'data' => 'string',
    //             'name' => 'testimonial_section_title',
    //             'label' => 'Title',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'What Our Students Say'
    //         ],
    //         [
    //             'type' => 'textarea',
    //             'data' => 'string',
    //             'name' => 'testimonial_section_description',
    //             'label' => 'Description',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => 'Lorem Ipsum is simply dummy text of the printing and typesetting Lorem Ipsum is simply dummy text of the printing.'
    //         ],
    //         [
    //             'type' => 'file', // input fields type
    //             'data' => 'file', // data type, string, int, boolean
    //             'name' => 'testimonial_section_bg', // unique name for field
    //             'label' => 'testimonial Section Bg', // you know what label it is
    //             'rules' => '', // validation rule of laravel
    //             'class' => '', // any class for input
    //             'value' => 'testimonial_section_bg.png' // default value if you want
    //         ],
    //     ]
    // ],


    'social' => [

        'title' => 'Social',
        'desc' => 'Social settings for app',
        'icon' => 'glyphicon glyphicon-envelope',

        'elements' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_fb',
                'label' => 'Facebook Link',
                'rules' => '',
                'class' => '',
                'value' => 'https://www.facebook.com/alumnibdchina'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_twitter',
                'label' => 'Twitter Link',
                'rules' => '',
                'class' => '',
                'value' => 'http://twitter.com/technohaat'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_instagram',
                'label' => 'Instagram Link',
                'rules' => '',
                'class' => '',
                'value' => 'http://instagram.com/technohaat'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_youtube',
                'label' => 'Youtube Link',
                'rules' => '',
                'class' => '',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_linkedin',
                'label' => 'Linkedin Link',
                'rules' => '',
                'class' => '',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_skype',
                'label' => 'Skype Link',
                'rules' => '',
                'class' => '',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_whatsapp',
                'label' => 'WhatsApp Link',
                'rules' => '',
                'class' => '',
                'value' => ''
            ],
            // [
            //     'type' => 'text',
            //     'data' => 'string',
            //     'name' => 'social_viber',
            //     'label' => 'Viber Link',
            //     'rules' => '',
            //     'class' => '',
            //     'value' => ''
            // ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_wechat',
                'label' => 'WeChat Link',
                'rules' => '',
                'class' => '',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'social_pinterest',
                'label' => 'Pinterest Link',
                'rules' => '',
                'class' => '',
                'value' => ''
            ],
        ]
    ],

    'footer' => [
        'title' => 'Footer',
        'desc' => 'All the general settings for footer.',
        'icon' => 'glyphicon glyphicon-sunglasses',

        'elements' => [
            [
                'type' => 'textarea', // input fields type
                'data' => 'string', // data type, string, int, boolean
                'name' => 'footer_quote', // unique name for field
                'label' => 'Quote', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'Claritas est etiam processus dynamicus, qui sequitur mutationem consuetudium lectorum. Mirum est notare.' // default value if you want
            ],
            [
                'type' => 'textarea', // input fields type
                'data' => 'string', // data type, string, int, boolean
                'name' => 'newsLetter_quote', // unique name for field
                'label' => 'NewsLetter Quote', // you know what label it is
                'rules' => '', // validation rule of laravel
                'class' => '', // any class for input
                'value' => 'Lorem ipsum dolor sit amet, consect etur adipisicing.' // default value if you want
            ],
        ]
    ],
    // 'custom' => [

    //     'title' => 'Style/Js',
    //     'desc' => 'Custom Style / JS',
    //     'icon' => 'glyphicon glyphicon-globe',

    //     'elements' => [
    //         [
    //             'type' => 'textarea',
    //             'data' => 'text',
    //             'name' => 'custom_css',
    //             'label' => 'Custom Css',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => ''
    //         ],
    //         [
    //             'type' => 'textarea',
    //             'data' => 'text',
    //             'name' => 'custom_js',
    //             'label' => 'Custom JS',
    //             'rules' => '',
    //             'class' => '',
    //             'value' => ''
    //         ],
    //     ]
    // ],
]

?>