<?php

namespace App\Models;

use \App\Model as Model;

/**
 * Class Story
 * @package App\Models
 * @version April 5, 2021, 6:54 pm UTC
 *
 * @property string name
 * @property string description
 * @property string image
 * @property integer status
 */
class Story extends Model
{

    public $table = 'stories';
    
    public static $video_type = [
        "" => "No Video",
        "1" => "Upload",
        "2" => "Youtube",
    ];


    public $upload_path = 'uploads/stories';
    public $upload_video_path = 'uploads/story_videos';

    public $search_fields = [
        'name',
        'description',
        'image',
        'status'
    ];
    public $fillable = [
        'name',
        'description',
        'image',
        'video_src',
        'youtube_src',
        'video_type',
        'status'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'description' => 'string',
        'image' => 'string',
        'status' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required',
        'image' => 'image|mimes:jpeg,png,jpg|max:2048',
        'video_src' => 'mimes:mp4|max:12048'
    ];

    
}
