<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class EventResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $event = new \App\Models\Event;
        $array =  parent::toArray($request);
        $array['image_src'] = url('/') . '/' . $event->upload_path . '/' . $this->image;
        $array['short_description'] = \Illuminate\Support\Str::limit(strip_tags($this->description), $limit = 250, $end = '...');
        $array['start_date_formatted'] = formated_date($this->start_date);
        $array['end_date_formatted'] = formated_date($this->end_date);
        $array['start_date_day'] = \Carbon\Carbon::parse($this->start_date)->format('d');
        $array['start_date_day_name'] = \Carbon\Carbon::parse($this->start_date)->isoFormat('ddd');
        return $array;
    }
}
