<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Publication;

class UpdatePublicationRequest extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return[
            'title' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:2048',
            'attachment' => 'mimes:pdf|max:10000'
        ];
        //$rules = Publication::$rules;

        //return $rules;
    }
}
